<?php
/**
 *Template name: Produse
 *Template post type: produse
 */
?>
<?php get_header() ?>
<div class="single_product_wrap">
    <img src="/wp-content/themes/twentytwentyone-child/assets/img/sfert_circles.png" alt="" class="top_circles">
    <div class="breadcrumbs">
        <div class="container">
            <ul>
                <li><a href="/"><?php echo pll_e('Acasa') ?></a></li>
                <li>/</li>
                <li><a href="<?php echo pll_e('/produse') ?>"><?php echo pll_e('produse') ?></a></li>
                <li>/</li>
                <li><span><?php the_title() ?></span></li>
            </ul>
        </div>
    </div>
    <div class="container">
        <div class="single_product">
            <div class="gallery_side">
                <div class="top_slider">
                    <?php the_content(); ?>
                </div>
                <div class="bottom_slider">
                    <?php the_content(); ?>
                </div>
            </div>
            <div class="text_side">
                <h1> <?php the_title() ?></h1>
                <div class="text">
                    <?php
                    if (get_field('culoare')) {
                        echo '<span><b>' . pll__('Culoare:') . '</b><span>' . get_field('culoare') . '</span></span>';
                    }
                    if (get_field('h')) {
                        echo '<span><b>H:</b><span>' . get_field('h') . '</span></span>';
                    }
                    if (get_field('l')) {
                        echo '<span><b>L:</b><span>' . get_field('l') . '</span></span>';
                    }
                    if (get_field('certificare')) {
                        echo '<span>' . get_field('certificare') . '</span>';
                    }
                    if (get_field('materie_prima')) {
                        echo '<span><b>' . pll__('Materie primă:') . '</b><span>' . get_field('materie_prima') . '</span></span>';
                    }
                    if (get_field('numar_straturi')) {
                        echo '<span><b>' . pll__('Număr straturi:') . '</b><span>' . get_field('numar_straturi') . '</span></span>';
                    }
                    if (get_field('gramaj')) {
                        echo '<span><b>' . pll__('Gramaj hârtie g/m2:') . '</b><span>' . get_field('gramaj') . '</span></span>';
                    }
                    if (get_field('latime_bobina')) {
                        echo '<span><b>' . pll__('Lățimea bobină m:') . '</b><span>' . get_field('latime_bobina') . '</span></span>';
                    }
                    if (get_field('diametru_exterior_bobina')) {
                        echo '<span><b>' . pll__('Diametru bobină mm:') . '</b><span>' . get_field('diametru_exterior_bobina') . '</span></span>';
                    }
                    if (get_field('diametru_tub_interior')) {
                        echo '<span><b>' . pll__('Diametru tub interior mm:') . '</b><span>' . get_field('diametru_tub_interior') . '</span></span>';
                    }
                    if (get_field('ambalare')) {
                        echo '<span><b>' . pll__('Ambalare:') . '</b><span>' . get_field('ambalare') . '</span></span>';
                    }
                    if (get_field('conditii_de_pastrare')) {
                        echo '<span><b>' . pll__('Condiții de depozitare:') . '</b><span>' . get_field('conditii_de_pastrare') . '</span></span>';
                    }
                    if (get_field('palet')) {
                        echo '<span><b>' . pll__('Palet:') . '</b><span>' . get_field('palet') . '</span></span>';
                    }
                    if (get_field('inaltime_palet')) {
                        echo '<span><b>' . pll__('Inaltime palet:') . '</b><span>' . get_field('inaltime_palet') . '</span></span>';
                    }
                    ?>
                </div>
            </div>
        </div>
        <div class="products">
            <h2><?php echo pll_e('Produse similare') ?></h2>
            <?php
            global $post;

            // Obține ID-ul postului curent
            $current_post_id = $post->ID;
            $terms = wp_get_post_terms($current_post_id, 'categorie'); // Înlocuiește 'category' cu numele taxonomiei tale, dacă este diferit

            if ($terms) {
                $term_ids = wp_list_pluck($terms, 'term_id');
                // Setăm argumentele interogării
                $args = array(
                    'post_type' => 'produse', // Înlocuiește cu slug-ul tipului de post personalizat
                    'posts_per_page' => '4',
                    'post__not_in' => array($current_post_id),
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'categorie', // Înlocuiește 'category' cu numele taxonomiei tale, dacă este diferit
                            'field' => 'term_id',
                            'terms' => $term_ids,
                        ),
                    ),
                );

                // Creăm noua interogare
                $custom_posts_query = new WP_Query($args);

                // Verificăm dacă avem postări
                if ($custom_posts_query->have_posts()) {
                    echo '<ul>';
                    while ($custom_posts_query->have_posts()) {
                        $custom_posts_query->the_post();
                        echo '<li>';
                        // Afișăm imaginea reprezentativă
                        if (has_post_thumbnail()) {
                            echo '<div class="post-thumbnail"><a href="' . get_the_permalink() . '">' . get_the_post_thumbnail(get_the_ID(), 'full') . '</a></div>';
                        }
                        echo '<div class="product_content">';

                        // Afișăm titlul și link-ul către postare
                        echo '<a href="' . get_the_permalink() . '"><h4>' . get_the_title() . '</h4></a>';
                        echo '</div>';
                        echo '</li>';
                    }
                    echo '</ul>';
                } else {
                    echo '<p>No posts found.</p>';
                }
                // Resetăm post data
                wp_reset_postdata();
            }
            ?>
        </div>
    </div>
</div>
<?php get_footer() ?>
