<?php
/**
 * Template name: Semifabricat
 * template post type: page
 */
?>
<?php get_header() ?>
<div class="characteristics_wrap">
    <img src="/wp-content/themes/twentytwentyone-child/assets/img/sfert_circles.png" alt="" class="top_circles">
    <div class="container">
        <div class="top_section">
            <div>
                <h6><?php echo pll_e('Caracteristici Tehnice') ?></h6>
                <h1><?php echo pll_e('Hârtie semifabricat ecologic pentru hârtie igienică') ?></h1>
            </div>
            <img src="/wp-content/themes/twentytwentyone-child/assets/img/bobine 2 buc.png" alt="">
        </div>
        <div class="characteristics">
            <div class="single_characteristic">
                <b><?php echo pll_e('Realizat din materiale reciclabile') ?></b>
                <p><?php echo pll_e('Produsul semifabricat pentru hârtie igienică este produs din materiale reciclate, oferind o soluție ecologică pentru fabricarea hârtiei igienice.') ?></p>
            </div>
            <div class="single_characteristic">
                <b><?php echo pll_e('Strat de bază uniform') ?></b>
                <p><?php echo pll_e('Utilizăm tehnologie avansată pentru a asigura o structură uniformă, garantând o calitate superioară a produsului finit.') ?></p>
            </div>
            <div class="single_characteristic">
                <b><?php echo pll_e('Durabilitate') ?></b>
                <p><?php echo pll_e('Proiectat pentru a asigura rezistența hârtiei igienice finale, semifabricatul are o structură robustă, care previne ruperea ușoară și garantează o utilizare eficientă.') ?></p>
            </div>
            <div class="single_characteristic">
                <b><?php echo pll_e('Procesare facilă') ?></b>
                <p><?php echo pll_e('Semifabricatul este conceput pentru a fi ușor de procesat în diverse etape de producție, optimizând eficiența fabricării.') ?></p>
            </div>
            <div class="single_characteristic">
                <b><?php echo pll_e('Complet biodegradabil') ?></b>
                <p><?php echo pll_e('Semifabricatul Candelux se descompune rapid în mediu, contribuind la reducerea impactului ecologic.') ?></p>
            </div>
            <div class="single_characteristic">
                <b><?php echo pll_e('100% inofensiv') ?></b>
                <p><?php echo pll_e('Semifabricatul nu conține parfumuri sau alte substanțe chimice, ceea ce îl face ideal pentru producția de hârtie igienică sigură pentru pielea sensibilă.') ?></p>
            </div>
        </div>
        <div class="advantages">
            <div class="distribution_terms">
                <div class="middle_section">
                    <div class="accordion_side">
                        <h3><?php echo pll_e('Avantaje ale utilizării') ?></h3>
                        <div class="accordion">
                            <div class="single_accordion">
                                <div class="accordion_header">
                                    <h5><?php echo pll_e('Eco-friendly') ?></h5>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                         fill="none">
                                        <path d="M19 9L12 16L5 9" stroke="#706C67" stroke-width="2"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="accordion_content">
                                    <p><?php echo pll_e('Alegerea semifabricatului Candelux susține reducerea deșeurilor și economisirea resurselor naturale, promovând un ciclu de producție sustenabil.') ?></p>
                                </div>
                            </div>
                            <div class="single_accordion">
                                <div class="accordion_header">
                                    <h5><?php echo pll_e('Calitate consistentă') ?></h5>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                         fill="none">
                                        <path d="M19 9L12 16L5 9" stroke="#706C67" stroke-width="2"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="accordion_content">
                                    <p><?php echo pll_e('Fabricat conform standardelor riguroase, semifabricatul asigură o calitate constantă în producția de hârtie igienică.') ?></p>
                                </div>
                            </div>
                            <div class="single_accordion">
                                <div class="accordion_header">
                                    <h5><?php echo pll_e('Eficiență în producție') ?></h5>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                         fill="none">
                                        <path d="M19 9L12 16L5 9" stroke="#706C67" stroke-width="2"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="accordion_content">
                                    <p><?php echo pll_e('Datorită ușurinței de procesare, semifabricatul nostru contribuie la reducerea timpului și costurilor de producție.') ?></p>
                                </div>
                            </div>
                            <div class="single_accordion">
                                <div class="accordion_header">
                                    <h5><?php echo pll_e('Reducerea amprentei ecologice') ?></h5>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                         fill="none">
                                        <path d="M19 9L12 16L5 9" stroke="#706C67" stroke-width="2"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="accordion_content">
                                    <p><?php echo pll_e('Prin utilizarea unui semifabricat biodegradabil, fabricanții contribuie la protejarea mediului înconjurător și la reducerea poluării.') ?></p>
                                </div>
                            </div>
                            <div class="single_accordion">
                                <div class="accordion_header">
                                    <h5><?php echo pll_e('Siguranță și sustenabilitate') ?></h5>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                         fill="none">
                                        <path d="M19 9L12 16L5 9" stroke="#706C67" stroke-width="2"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="accordion_content">
                                    <p><?php echo pll_e('Fără substanțe chimice nocive, semifabricatul Candelux este o opțiune sigură și responsabilă pentru producătorii de hârtie igienică.') ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="bottom_text">
                            <h2><?php echo pll_e('Utilizare versatilă') ?></h2>
                            <p><?php echo pll_e('Semifabricatul Candelux pentru hârtie igienică este ideal pentru producători care doresc să creeze produse de calitate superioară, respectând în același timp principiile sustenabilității. Este potrivit pentru toate tipurile de echipamente standard de fabricație a hârtiei igienice, oferind flexibilitate și eficiență în procesul de producție.') ?></p>
                            <p><?php echo pll_e('Alegerea acestui material nu doar că promovează practicile ecologice, dar asigură și un produs final durabil, eficient și sigur pentru consumatori.') ?></p>
                        </div>
                    </div>
                    <div class="img_side">
                        <img src="/wp-content/themes/twentytwentyone-child/assets/img/semi1.png" alt="">
                        <img src="/wp-content/themes/twentytwentyone-child/assets/img/semi2.png" alt="">
                    </div>
                </div>
            </div>
        </div>
        <div class="products semifabricat">
            <?php
            // Setăm argumentele interogării
            $args = array(
                'post_type' => 'produse', // Înlocuiește cu slug-ul tipului de post personalizat
                'posts_per_page' => '4',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'categorie',
                        'field' => 'slug',
                        'terms' => 'hartie-semifabricat',
                    ),
                ),
            );

            // Creăm noua interogare
            $custom_posts_query = new WP_Query($args);

            // Verificăm dacă avem postări
            if ($custom_posts_query->have_posts()) {
                echo '<ul>';
                while ($custom_posts_query->have_posts()) {
                    $custom_posts_query->the_post();
                    echo '<li>';
                    // Afișăm imaginea reprezentativă
                    if (has_post_thumbnail()) {
                        echo '<div class="post-thumbnail"><a href="' . get_the_permalink() . '">' . get_the_post_thumbnail(get_the_ID(), 'full') . '</a></div>';
                    }
                    echo '<div class="product_content">';

                    // Afișăm titlul și link-ul către postare
                    echo '<a href="' . get_the_permalink() . '"><h4>' . get_the_title() . '</h4></a>';

                    echo '</div>';
                    echo '</li>';
                }
                echo '</ul>';
            } else {
                echo '<p>No posts found.</p>';
            }
            // Resetăm post data
            wp_reset_postdata();

            ?>
            <a href="<?php echo pll_e('/categorie/semifabricat-hartie-igienica/') ?>" class="see_all">
                <?php echo pll_e('Vezi toate produsele') ?>
            </a>
        </div>
    </div>
</div>

<?php get_footer() ?>
