<?php
/*
 * Template name: Producere
 * Template post type: Page
 */
?>
<?php get_header() ?>
<div class="producere">

    <div class="container">
        <h6><?php echo pll_e('producere') ?></h6>
        <div class="top_section">
            <h2><?php echo pll_e('De la materie primă la produs finit') ?></h2>
            <div class="top_section_blocks">
                <div class="single_block">
                    <div class="img_wrap">
                        <img src="/wp-content/themes/twentytwentyone-child/assets/img/block1.png" alt="">
                        <img class="points" src="/wp-content/themes/twentytwentyone-child/assets/img/circles.png"
                             alt="">
                        <div class="number1"><span>1</span></div>
                    </div>
                    <div class="text">
                        <h4><?php echo pll_e('Pasul 1: Colectare materie primă') ?></h4>
                        <p><?php echo pll_e('Materiile prime pentru producere sunt colectate în principal din maculatură. Aceasta este adunată de la tipografii, combinate poligrafice și de la persoane fizice.') ?></p>
                    </div>
                </div>
                <div class="single_block">
                    <div class="img_wrap">
                        <img src="/wp-content/themes/twentytwentyone-child/assets/img/producere2.png" alt="">
                        <div class="number1"><span>2</span></div>
                    </div>
                    <div class="text">
                        <h4><?php echo pll_e('Pasul 2: Fabricare') ?></h4>
                        <p><?php echo pll_e('Maculatura este introdusă într-un proces de fabricare a hârtiei, care implică amestecarea fibrelor de hârtie cu apă pentru a forma o pastă, care este ulterior comprimată și uscată pentru a forma role de hârtie') ?></p>
                    </div>
                </div>
                <div class="single_block">
                    <div class="img_wrap">
                        <img src="/wp-content/themes/twentytwentyone-child/assets/img/producere3.png" alt="">
                        <img class="points" src="/wp-content/themes/twentytwentyone-child/assets/img/circles.png"
                             alt="">
                        <div class="number1"><span>3</span></div>
                    </div>
                    <div class="text">
                        <h4><?php echo pll_e('Pasul 3: Produs finit') ?></h4>
                        <p><?php echo pll_e('Rolele de hârtie igienică produse sunt supuse unor operațiuni de finisare pentru a le conferi caracteristicile dorite, fiind ambalată în mod corespunzător și pregătită pentru distribuție și comercializare') ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="bottom_section">
            <div class="left_side">
                <h6 class="subtitle"><?php echo pll_e('Tehnologie și inovație') ?></h6>
                <h2><?php echo pll_e('O evoluție continuă prin inovație și tehnologie') ?></h2>
            </div>
            <div class="right_side">
                <div class="accordion">
                    <div class="single_accordion">
                        <div class="accordion_header">
                            <h5><?php echo pll_e('Eficiență sporită') ?></h5>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M19 9L12 16L5 9" stroke="#111827" stroke-width="2" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="accordion_content">
                            <p><?php echo pll_e('Utilizarea tehnologiilor moderne, cum ar fi mașinile cu control numeric computerizat (CNC), automatizarea liniei de producție și sistemele de monitorizare și control al procesului, contribuie la optimizarea eficienței operaționale și la reducerea timpului de producție.') ?></p>
                        </div>
                    </div>
                    <div class="single_accordion">
                        <div class="accordion_header">
                            <h5><?php echo pll_e('Calitate îmbunătățită') ?></h5>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M19 9L12 16L5 9" stroke="#111827" stroke-width="2" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="accordion_content">
                            <p><?php echo pll_e('Tehnologia avansată permite monitorizarea și controlul precis al parametrilor de producție, asigurând o calitate uniformă a produsului finit. Sistemele avansate de inspecție vizuală și senzori pot detecta și corecta automat eventualele defecte în timpul procesului de fabricație.') ?></p>
                        </div>
                    </div>
                    <div class="single_accordion">
                        <div class="accordion_header">
                            <h5><?php echo pll_e('Diversificare și personalizare') ?></h5>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M19 9L12 16L5 9" stroke="#111827" stroke-width="2" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="accordion_content">
                            <p><?php echo pll_e('Tehnologia modernă permite adaptarea rapidă a liniei de producție pentru a satisface cerințele pieței în schimbare și pentru a produce o varietate mai mare de produse și dimensiuni. De exemplu, mașinile de tăiere și ambalare pot fi configurate rapid pentru a produce role de dimensiuni diferite sau pentru a aplica modele și designuri personalizate.') ?></p>
                        </div>
                    </div>
                    <div class="single_accordion">
                        <div class="accordion_header">
                            <h5><?php echo pll_e('Sustenabilitate sporită') ?></h5>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M19 9L12 16L5 9" stroke="#111827" stroke-width="2" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="accordion_content">
                            <p><?php echo pll_e('Inovațiile în tehnologia de producție permit reducerea consumului de resurse naturale, energie și apă, precum și minimizarea deșeurilor și emisiilor. Procesele de reciclare și refolosire a materialelor sunt integrate în mod obișnuit în procesul de producție, contribuind la reducerea impactului asupra mediului înconjurător.') ?></p>
                        </div>
                    </div>
                    <div class="single_accordion">
                        <div class="accordion_header">
                            <h5><?php echo pll_e('Îmbunătățirea condițiilor de muncă') ?></h5>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M19 9L12 16L5 9" stroke="#111827" stroke-width="2" stroke-linecap="round"
                                      stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="accordion_content">
                            <p><?php echo pll_e('Tehnologia avansată poate reduce munca manuală și riscul de accidente la locul de muncă, oferind un mediu mai sigur și mai confortabil pentru operatori. Automatizarea anumitor sarcini repetitive și solicitante permite lucrătorilor să se concentreze pe activități de control și optimizare a procesului.') ?></p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class="call_to_certificate">
        <img src="/wp-content/themes/twentytwentyone-child/assets/img/call_left.png" alt="" class="call_left">
        <div class="container">
            <div class="certificate_content">
                <h3><?php echo pll_e('Calitatea care inspiră încredere și respect universal.') ?></h3>
                <p><?php echo pll_e('Certificările noastre reflectă angajamentul nostru profund pentru calitate, sustenabilitate și excelență în toate aspectele activității noastre') ?></p>
                <a href="<?php echo pll_e('/certificari/') ?>"><?php echo pll_e('Vezi certificările') ?></a>
            </div>
        </div>
        <img src="/wp-content/themes/twentytwentyone-child/assets/img/call_right.png" alt="" class="call_right">
    </div>
</div>
<?php get_footer() ?>
