<?php
/*
 * Template name: Home
 * Template post type: Page
 */
?>
<?php get_header() ?>
<div class="main_section">
    <video autoplay muted loop>
        <source src="/wp-content/themes/twentytwentyone-child/assets/img/main-video.mp4">
    </video>

    <div class="content">
        <h2>
            <span><?php echo pll_e('Reciclăm.') ?></span>
            <span><?php echo pll_e('Protejăm.') ?></span>
            <span><?php echo pll_e('Utilizăm.') ?></span>
        </h2>
        <p><?php echo pll_e('Bine ai venit la Fabrica de Hârtie! Suntem sursa ta de încredere pentru produse din hârtie de cea mai înaltă calitate. Descoperă gama noastră de produse și servicii sau contactează-ne pentru soluții personalizate.') ?></p>
        <div class="button_wrap">
            <a href="<?php echo pll_e('/produse') ?>"><?php echo pll_e('Descoperă produsele') ?></a>
        </div>
    </div>
</div>
<div class="container">
    <div class="home_products">
        <div class="section_details">
            <h2><?php echo pll_e('Produse proprii') ?></h2>
            <p><?php echo pll_e('În preocuparea noastră constantă pentru mediul înconjurător, produsele noastre sunt realizate din materiale reciclabile și biodegradabile, contribuind la reducerea impactului asupra mediului.') ?></p>
        </div>
        <div class="product_categories">
            <a href="<?php echo pll_e('/hartie-igienica') ?>" class="category">
                <span class="img_wrap">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/compozitie 3 buc.png" alt="">
                </span>
                <div class="category_content">
                    <h2><?php echo pll_e('Hârtie igienică') ?></h2>
                    <p><?php echo pll_e('Hârtia igienică din hârtie reciclată este o alegere eco-friendly pentru cei care doresc să contribuie la protecția mediului înconjurător, fiind o opțiune sustenabilă și responsabilă pentru uzul zilnic, fără a compromite calitatea și confortul.') ?></p>
                </div>
            </a>
            <a href="<?php echo pll_e('/semifabricat-ecologic/') ?>" class="category">
                                <span class="img_wrap">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/bobine 2 buc.png"
                     alt="">
                                </span>
                <div class="category_content">
                    <h2><?php echo pll_e('Hârtie semifabricat') ?></h2>
                    <p><?php echo pll_e('Hârtia semifabricat din hârtie reciclată este un produs intermediar esențial în procesul de fabricație a hârtiei igienice ecologice.') ?></p>
                </div>
            </a>
        </div>
    </div>
    <div class="partners">
        <h3><?php echo pll_e('Parteneri') ?></h3>
        <img src="/wp-content/themes/twentytwentyone-child/assets/img/logo1.png" alt="">
        <img src="/wp-content/themes/twentytwentyone-child/assets/img/logo2.png" alt="">
        <img src="/wp-content/themes/twentytwentyone-child/assets/img/logo3.png" alt="">
        <img src="/wp-content/themes/twentytwentyone-child/assets/img/logo6.png" alt="">
        <img src="/wp-content/themes/twentytwentyone-child/assets/img/logo5.png" alt="">
        <img src="/wp-content/themes/twentytwentyone-child/assets/img/logo4.png" alt="">

    </div>
</div>


<?php get_footer() ?>
