<?php
/**
 * Template name: Hartie Igienica
 * template post type: page
 */
?>
<?php get_header() ?>
<div class="characteristics_wrap">
    <img src="/wp-content/themes/twentytwentyone-child/assets/img/sfert_circles.png" alt="" class="top_circles">
    <div class="container">
        <div class="top_section">
            <div>
                <h6><?php echo pll_e('Caracteristici Tehnice') ?></h6>
                <h1><?php echo pll_e('Hârtie igienică ecologică') ?></h1>
            </div>
            <img src="/wp-content/themes/twentytwentyone-child/assets/img/compozitie 3 buc.png" alt="">
        </div>
        <div class="characteristics">
            <div class="single_characteristic">
                <b><?php echo pll_e('100% ecologică') ?></b>
                <p><?php echo pll_e('Hârtie igienică produsă exclusiv din materiale reciclate, contribuind activ la protejarea mediului înconjurător.') ?></p>
            </div>
            <div class="single_characteristic">
                <b><?php echo pll_e('Textură echilibrată') ?></b>
                <p><?php echo pll_e('Textura echilibrată oferă o combinație ideală între confort și funcționalitate. Este o alternativă reală la produse de igienă convenționale.') ?></p>
            </div>
            <div class="single_characteristic">
                <b><?php echo pll_e('Rezistentă și absorbantă') ?></b>
                <p><?php echo pll_e('Proiectată pentru a fi durabilă și absorbantă, hârtia igienică gestionează eficient umezeala, oferind o curățenie optimă.') ?></p>
            </div>
            <div class="single_characteristic">
                <b><?php echo pll_e('Complet biodegradabilă') ?></b>
                <p><?php echo pll_e('Se descompune rapid și natural, reducând impactul negativ asupra mediului.') ?></p>
            </div>
            <div class="single_characteristic">
                <b><?php echo pll_e('Ambalaj prietenos cu mediul') ?></b>
                <p><?php echo pll_e('Ambalajul hârtiei igienice Candelux este realizat din materiale reciclabile, contribuind astfel la reducerea deșeurilor de plastic.') ?></p>
            </div>
            <div class="single_characteristic">
                <b><?php echo pll_e('Sigură pentru piele') ?></b>
                <p><?php echo pll_e('Fără parfumuri și chimicale, este ideală pentru toate tipurile de piele, inclusiv cea sensibilă.') ?></p>
            </div>
        </div>
        <div class="advantages">
            <div class="distribution_terms">
                <div class="middle_section">
                    <div class="accordion_side">
                        <h3><?php echo pll_e('Avantaje ale utilizării') ?></h3>
                        <div class="accordion">
                            <div class="single_accordion">
                                <div class="accordion_header">
                                    <h5><?php echo pll_e('Eco-friendly') ?></h5>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                         fill="none">
                                        <path d="M19 9L12 16L5 9" stroke="#706C67" stroke-width="2"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="accordion_content">
                                    <p><?php echo pll_e('Alegând hârtia igienică Candelux, faceți un pas important spre un stil de viață mai sustenabil și sănătos.') ?></p>
                                </div>
                            </div>
                            <div class="single_accordion">
                                <div class="accordion_header">
                                    <h5><?php echo pll_e('Rezistență și eficiență') ?></h5>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                         fill="none">
                                        <path d="M19 9L12 16L5 9" stroke="#706C67" stroke-width="2"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="accordion_content">
                                    <p><?php echo pll_e('Durabilitatea hârtiei previne deteriorarea în utilizare, oferind o soluție fiabilă pentru uzul zilnic.') ?></p>
                                </div>
                            </div>
                            <div class="single_accordion">
                                <div class="accordion_header">
                                    <h5><?php echo pll_e('Reducerea amprentei ecologice') ?></h5>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                         fill="none">
                                        <path d="M19 9L12 16L5 9" stroke="#706C67" stroke-width="2"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="accordion_content">
                                    <p><?php echo pll_e('Prin utilizarea unui produs complet biodegradabil, contribui la protejarea ecosistemelor și la reducerea poluării.') ?></p>
                                </div>
                            </div>
                            <div class="single_accordion">
                                <div class="accordion_header">
                                    <h5><?php echo pll_e('Calitate') ?></h5>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                         fill="none">
                                        <path d="M19 9L12 16L5 9" stroke="#706C67" stroke-width="2"
                                              stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="accordion_content">
                                    <p><?php echo pll_e('În pofida materialelor reciclate folosite, hârtia igienică Candelux oferă o calitate comparabilă cu produsele tradiționale.') ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="bottom_text">
                            <h2><?php echo pll_e('Utilizare versatilă') ?></h2>
                            <p><?php echo pll_e('Hârtia igienică Candelux este ideală pentru diverse medii, inclusiv acasă, în birouri, instituții și alte spații publice. Compatibilă cu toate tipurile de dozatoare standard, asigură o utilizare simplă și eficientă.') ?></p>
                        </div>
                    </div>
                    <div class="img_side">
                        <img src="/wp-content/themes/twentytwentyone-child/assets/img/hartie1.png" alt="">
                        <img src="/wp-content/themes/twentytwentyone-child/assets/img/hartie2.png" alt="">
                    </div>
                </div>
            </div>
        </div>
        <div class="products">
            <?php
            // Setăm argumentele interogării
            $args = array(
                'post_type' => 'produse', // Înlocuiește cu slug-ul tipului de post personalizat
                'posts_per_page' => '4',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'categorie',
                        'field' => 'slug',
                        'terms' => 'hartie-igienica',
                    ),
                ),
            );

            // Creăm noua interogare
            $custom_posts_query = new WP_Query($args);

            // Verificăm dacă avem postări
            if ($custom_posts_query->have_posts()) {
                echo '<ul>';
                while ($custom_posts_query->have_posts()) {
                    $custom_posts_query->the_post();
                    echo '<li>';
                    // Afișăm imaginea reprezentativă
                    if (has_post_thumbnail()) {
                        echo '<div class="post-thumbnail"><a href="' . get_the_permalink() . '">' . get_the_post_thumbnail(get_the_ID(), 'full') . '</a></div>';
                    }
                    echo '<div class="product_content">';

                    // Afișăm titlul și link-ul către postare
                    echo '<a href="' . get_the_permalink() . '"><h4>' . get_the_title() . '</h4></a>';

                    echo '</div>';
                    echo '</li>';
                }
                echo '</ul>';
            } else {
                echo '<p>No posts found.</p>';
            }
            // Resetăm post data
            wp_reset_postdata();

            ?>
            <a href="<?php echo pll_e('/categorie/hartie-igienica/') ?>" class="see_all">
                <?php echo pll_e('Vezi toate produsele') ?>
            </a>
        </div>
    </div>
</div>

<?php get_footer() ?>
