<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
</main><!-- #main -->
</div><!-- #primary -->
</div><!-- #content -->

<?php get_template_part('template-parts/footer/footer-widgets'); ?>

<footer id="colophon" class="site-footer">
    <a href="#" id="back-to-top" class="back_to_top">
        <img src="/wp-content/themes/twentytwentyone-child/assets/img/arrow_right.svg" alt="Arrow Top"
             loading="lazy">
    </a>
    <div class="container">
        <div class="footer_content">
            <div class="column">
                <div class="site-info">
                    <div class="site-name">
                        <svg xmlns="http://www.w3.org/2000/svg" width="195" height="49" viewBox="0 0 195 49"
                             fill="none">
                            <path d="M90.3601 22.4C90.2201 22.4 89.9801 22.3499 89.6301 22.2599C89.2801 22.1699 88.8701 22.07 88.4101 21.97C87.9501 21.87 87.4501 21.77 86.9201 21.68C86.3901 21.59 85.8801 21.54 85.3801 21.54C85.0001 21.54 84.5801 21.58 84.1401 21.66C83.7001 21.74 83.2901 21.88 82.9201 22.09C82.5501 22.29 82.2401 22.55 81.9901 22.87C81.7401 23.19 81.6201 23.58 81.6201 24.06C81.6201 24.44 81.7301 24.8 81.9401 25.12C82.1501 25.44 82.4401 25.72 82.8001 25.95C83.1601 26.19 83.5801 26.3799 84.0501 26.5099C84.5201 26.6499 85.0301 26.71 85.5701 26.71C86.2001 26.71 86.8001 26.6 87.3601 26.39C87.9201 26.17 88.4301 25.9 88.8701 25.59C89.3101 25.27 89.6601 24.9299 89.9201 24.5699C90.1801 24.1999 90.3201 23.88 90.3401 23.58V22.39L90.3601 22.4ZM93.4701 22.33V24.85C93.4701 25.67 93.4701 26.41 93.4501 27.05C93.4401 27.69 93.4301 28.21 93.4301 28.61V29.24H90.3201V27.47C89.6701 28.28 88.8801 28.85 87.9501 29.18C87.0301 29.51 86.0801 29.68 85.1101 29.68C84.3201 29.68 83.5301 29.5599 82.7401 29.3199C81.9501 29.0799 81.2401 28.73 80.6101 28.25C79.9801 27.78 79.4701 27.18 79.0901 26.47C78.7101 25.76 78.5101 24.93 78.5101 23.98C78.5101 23.03 78.6701 22.17 79.0001 21.48C79.3301 20.78 79.7801 20.21 80.3501 19.77C80.9301 19.33 81.6001 19.04 82.3801 18.84C83.1601 18.64 84.0101 18.5 84.9401 18.5C85.7501 18.5 86.6201 18.57 87.5301 18.7C88.4401 18.84 89.3701 19.05 90.3201 19.34V19.2C90.3701 19.02 90.3901 18.86 90.3901 18.73V18.29C90.3901 17.68 90.2701 17.15 90.0301 16.7C89.7901 16.25 89.4801 15.88 89.1001 15.58C88.7201 15.29 88.2801 15.07 87.8001 14.92C87.3101 14.77 86.8101 14.7 86.2901 14.7C85.7701 14.7 85.3101 14.76 84.8301 14.87C84.3601 14.98 83.9301 15.16 83.5401 15.41C83.0201 15.74 82.2101 16.3 82.1901 16.95L79.0801 17.68C79.1501 16.69 79.3901 15.8199 79.8101 15.0699C80.2301 14.3299 80.7601 13.71 81.4001 13.23C82.0401 12.74 82.7701 12.38 83.5801 12.13C84.3901 11.88 85.2301 11.7599 86.0801 11.7599C87.0701 11.7599 88.0101 11.9 88.8901 12.17C89.7701 12.44 90.5401 12.87 91.2101 13.46C91.8801 14.05 92.4101 14.8 92.8001 15.71C93.1901 16.62 93.4001 17.74 93.4301 19.04V19.21C93.7701 19.16 94.1101 19.11 94.4601 19.04C94.8101 18.97 95.1801 18.89 95.5601 18.8V21.98L93.4601 22.3199L93.4701 22.33ZM76.1401 22.3C75.6901 23.59 75.0001 24.7599 74.0801 25.8199C73.1601 26.8799 72.0301 27.75 70.7001 28.43C69.1201 29.22 67.4601 29.61 65.7201 29.61C64.6401 29.61 63.6001 29.47 62.6101 29.19C61.6201 28.91 60.6901 28.5 59.8301 27.97C58.9701 27.44 58.2001 26.8 57.5101 26.06C56.8201 25.32 56.2401 24.47 55.7701 23.52C55.3901 22.73 55.1001 21.92 54.9101 21.08C54.7201 20.24 54.6201 19.42 54.6201 18.61C54.6201 17.59 54.7601 16.59 55.0401 15.6C55.3201 14.61 55.7201 13.68 56.2401 12.81C56.7601 11.94 57.4001 11.15 58.1701 10.44C58.9401 9.73 59.8101 9.13 60.7801 8.63C62.4001 7.84 64.0901 7.44995 65.8201 7.44995C66.8801 7.44995 67.9001 7.59 68.8801 7.87C69.8601 8.15 70.7801 8.55997 71.6401 9.08997C72.5001 9.61997 73.2701 10.26 73.9601 11C74.6501 11.74 75.2301 12.59 75.7001 13.54C75.9501 14.01 76.1501 14.48 76.3101 14.93C75.5001 14.93 74.8801 14.93 74.4501 14.91C74.0201 14.9 73.7101 14.89 73.5001 14.89C73.2901 14.89 73.1701 14.89 73.1301 14.87C73.0801 14.86 73.0601 14.85 73.0601 14.85C72.3801 13.45 71.4001 12.3599 70.1001 11.5699C68.8001 10.7799 67.3801 10.39 65.8201 10.39C64.4901 10.39 63.2501 10.68 62.1001 11.27C61.3801 11.63 60.7401 12.08 60.1901 12.61C59.6401 13.14 59.1701 13.73 58.7901 14.37C58.4101 15.01 58.1101 15.7 57.9101 16.42C57.7101 17.14 57.6101 17.88 57.6101 18.62C57.6101 19.86 57.8901 21.06 58.4601 22.21C59.1401 23.61 60.1201 24.7 61.4201 25.49C62.7201 26.28 64.1601 26.67 65.7401 26.67C66.9601 26.67 68.1801 26.38 69.4001 25.79C70.1901 25.41 70.8901 24.91 71.5001 24.3C72.1101 23.69 72.6101 23.03 72.9901 22.3H76.1701H76.1401Z"
                                  stroke="white" stroke-width="0.7" stroke-linecap="square" stroke-linejoin="round"/>
                            <path d="M90.3601 22.4C90.2201 22.4 89.9801 22.3599 89.6301 22.2599C89.2801 22.1699 88.8701 22.07 88.4101 21.97C87.9501 21.87 87.4501 21.77 86.9201 21.68C86.3901 21.59 85.8801 21.54 85.3801 21.54C85.0001 21.54 84.5801 21.58 84.1401 21.66C83.7001 21.74 83.2901 21.88 82.9201 22.09C82.5501 22.29 82.2401 22.55 81.9901 22.87C81.7401 23.19 81.6201 23.58 81.6201 24.06C81.6201 24.44 81.7301 24.8 81.9401 25.12C82.1501 25.44 82.4401 25.72 82.8001 25.95C83.1601 26.19 83.5801 26.3799 84.0501 26.5099C84.5201 26.6499 85.0301 26.71 85.5701 26.71C86.2001 26.71 86.8001 26.6 87.3601 26.39C87.9201 26.17 88.4301 25.9 88.8701 25.59C89.3101 25.27 89.6601 24.9299 89.9201 24.5699C90.1801 24.1999 90.3201 23.88 90.3401 23.58V22.39L90.3601 22.4ZM93.4701 22.33V24.85C93.4701 25.67 93.4701 26.41 93.4501 27.05C93.4301 27.69 93.4301 28.21 93.4301 28.61V29.24H90.3201V27.47C89.6701 28.28 88.8801 28.85 87.9501 29.18C87.0301 29.51 86.0801 29.68 85.1101 29.68C84.3201 29.68 83.5301 29.5599 82.7401 29.3199C81.9501 29.0799 81.2401 28.73 80.6101 28.25C79.9801 27.78 79.4701 27.18 79.0901 26.47C78.7101 25.76 78.5101 24.93 78.5101 23.98C78.5101 23.03 78.6701 22.17 79.0001 21.48C79.3301 20.78 79.7801 20.21 80.3501 19.77C80.9301 19.33 81.6001 19.04 82.3801 18.84C83.1601 18.64 84.0101 18.5 84.9401 18.5C85.7501 18.5 86.6201 18.57 87.5301 18.7C88.4401 18.84 89.3701 19.05 90.3201 19.34V19.2C90.3701 19.02 90.3901 18.86 90.3901 18.73V18.29C90.3901 17.68 90.2701 17.15 90.0301 16.7C89.7901 16.25 89.4801 15.88 89.1001 15.58C88.7201 15.29 88.2801 15.07 87.8001 14.92C87.3101 14.77 86.8101 14.7 86.2901 14.7C85.7701 14.7 85.3101 14.76 84.8301 14.87C84.3601 14.98 83.9301 15.16 83.5401 15.41C83.0201 15.74 82.2101 16.3 82.1901 16.95L79.0801 17.68C79.1501 16.69 79.3901 15.8199 79.8101 15.0699C80.2301 14.3299 80.7601 13.71 81.4001 13.23C82.0401 12.74 82.7701 12.38 83.5801 12.13C84.3901 11.88 85.2301 11.7599 86.0801 11.7599C87.0701 11.7599 88.0101 11.9 88.8901 12.17C89.7701 12.44 90.5401 12.87 91.2101 13.46C91.8801 14.05 92.4101 14.8 92.8001 15.71C93.1901 16.62 93.4001 17.74 93.4301 19.04V19.21C93.7701 19.16 94.1101 19.11 94.4601 19.04C94.8101 18.97 95.1801 18.89 95.5601 18.8V21.98L93.4601 22.3199L93.4701 22.33ZM76.1401 22.3C75.6901 23.59 75.0001 24.7599 74.0801 25.8199C73.1501 26.8799 72.0301 27.75 70.7001 28.43C69.1201 29.22 67.4601 29.61 65.7201 29.61C64.6401 29.61 63.6001 29.47 62.6101 29.19C61.6201 28.91 60.6901 28.5 59.8301 27.97C58.9701 27.44 58.2001 26.8 57.5101 26.06C56.8201 25.32 56.2401 24.47 55.7701 23.52C55.3901 22.73 55.1001 21.92 54.9101 21.08C54.7201 20.24 54.6201 19.42 54.6201 18.61C54.6201 17.59 54.7601 16.59 55.0401 15.6C55.3201 14.61 55.7201 13.68 56.2401 12.81C56.7601 11.94 57.4001 11.15 58.1701 10.44C58.9401 9.73 59.8101 9.13 60.7801 8.63C62.4001 7.84 64.0901 7.44995 65.8201 7.44995C66.8801 7.44995 67.9001 7.59 68.8801 7.87C69.8601 8.15 70.7801 8.55997 71.6401 9.08997C72.5001 9.61997 73.2701 10.26 73.9601 11C74.6501 11.74 75.2301 12.59 75.7001 13.54C75.9501 14.01 76.1501 14.48 76.3101 14.93C75.5001 14.93 74.8801 14.93 74.4501 14.91C74.0201 14.9 73.7101 14.89 73.5001 14.89C73.2901 14.89 73.1701 14.89 73.1301 14.87C73.0801 14.86 73.0601 14.85 73.0601 14.85C72.3801 13.45 71.4001 12.3599 70.1001 11.5699C68.8001 10.7799 67.3801 10.39 65.8201 10.39C64.4901 10.39 63.2501 10.68 62.1001 11.27C61.3801 11.63 60.7401 12.08 60.1901 12.61C59.6401 13.14 59.1701 13.73 58.7901 14.37C58.4101 15.01 58.1101 15.7 57.9101 16.42C57.7101 17.14 57.6101 17.88 57.6101 18.62C57.6101 19.86 57.8901 21.06 58.4601 22.21C59.1401 23.61 60.1201 24.7 61.4201 25.49C62.7201 26.28 64.1601 26.67 65.7401 26.67C66.9601 26.67 68.1801 26.38 69.4001 25.79C70.1901 25.41 70.8901 24.91 71.5001 24.3C72.1101 23.69 72.6101 23.03 72.9901 22.3H76.1701H76.1401Z"
                                  fill="white"/>
                            <path d="M100.659 14.72C100.819 14.11 101.119 13.61 101.559 13.21C101.999 12.82 102.469 12.51 102.979 12.3C103.489 12.09 103.989 11.94 104.489 11.86C104.989 11.78 105.369 11.74 105.639 11.74C106.929 11.74 108.039 11.9 108.969 12.21C109.909 12.53 110.669 13.02 111.269 13.7C111.869 14.38 112.309 15.26 112.609 16.36C112.899 17.45 113.049 18.78 113.049 20.34V29.31H109.999V20.24C109.999 19.54 109.939 18.87 109.829 18.24C109.719 17.61 109.499 17.04 109.189 16.55C108.869 16.05 108.449 15.65 107.899 15.35C107.359 15.05 106.649 14.86 105.769 14.79C105.159 14.79 104.549 14.9 103.939 15.13C103.329 15.36 102.789 15.69 102.319 16.13C101.849 16.57 101.459 17.11 101.149 17.74C100.849 18.37 100.689 19.09 100.689 19.91V29.3199H97.6094V12.36H100.689L100.659 14.73V14.72Z"
                                  stroke="white" stroke-width="0.7" stroke-linecap="square" stroke-linejoin="round"/>
                            <path d="M100.659 14.72C100.819 14.11 101.119 13.61 101.559 13.21C101.999 12.82 102.469 12.51 102.979 12.3C103.489 12.09 103.989 11.94 104.489 11.86C104.989 11.78 105.369 11.74 105.639 11.74C106.929 11.74 108.039 11.9 108.969 12.21C109.909 12.53 110.669 13.02 111.269 13.7C111.869 14.38 112.309 15.26 112.609 16.36C112.899 17.45 113.049 18.78 113.049 20.34V29.31H109.999V20.24C109.999 19.54 109.939 18.87 109.829 18.24C109.719 17.61 109.499 17.04 109.189 16.55C108.869 16.05 108.449 15.65 107.899 15.35C107.359 15.05 106.649 14.86 105.769 14.79C105.159 14.79 104.549 14.9 103.939 15.13C103.329 15.36 102.789 15.69 102.319 16.13C101.849 16.57 101.459 17.11 101.149 17.74C100.849 18.37 100.689 19.09 100.689 19.91V29.3199H97.6094V12.36H100.689L100.659 14.73V14.72Z"
                                  fill="white"/>
                            <path d="M118.67 21.18C118.74 22.08 118.95 22.86 119.3 23.52C119.65 24.17 120.1 24.72 120.65 25.14C121.2 25.57 121.82 25.88 122.51 26.09C123.2 26.29 123.91 26.39 124.66 26.39C125.18 26.39 125.71 26.34 126.25 26.24C126.79 26.14 127.29 25.9999 127.74 25.8199V15.77C127.4 15.59 126.95 15.45 126.39 15.36C125.83 15.27 125.35 15.22 124.97 15.22C123.03 15.22 121.5 15.68 120.37 16.59C119.24 17.5 118.68 19.03 118.68 21.18H118.67ZM115.76 20.67C115.76 19.59 115.95 18.53 116.32 17.49C116.69 16.45 117.24 15.52 117.96 14.7C118.68 13.88 119.57 13.22 120.62 12.72C121.67 12.22 122.88 11.98 124.26 11.98C124.82 11.98 125.45 12.03 126.14 12.12C126.83 12.21 127.36 12.37 127.75 12.59V7.44995H130.9V28.33C129.97 28.76 129.02 29.08 128.04 29.29C127.06 29.5 126.09 29.61 125.15 29.61C123.91 29.61 122.72 29.42 121.6 29.03C120.47 28.65 119.47 28.08 118.6 27.34C117.73 26.6 117.04 25.66 116.54 24.55C116.03 23.43 115.78 22.14 115.78 20.67H115.76Z"
                                  stroke="white" stroke-width="0.7" stroke-linecap="square" stroke-linejoin="round"/>
                            <path d="M118.67 21.18C118.74 22.08 118.95 22.86 119.3 23.52C119.65 24.17 120.1 24.72 120.65 25.14C121.2 25.57 121.82 25.88 122.51 26.09C123.2 26.29 123.91 26.39 124.66 26.39C125.18 26.39 125.71 26.34 126.25 26.24C126.79 26.14 127.29 25.9999 127.74 25.8199V15.77C127.4 15.59 126.95 15.45 126.39 15.36C125.83 15.27 125.35 15.22 124.97 15.22C123.03 15.22 121.5 15.68 120.37 16.59C119.24 17.5 118.68 19.03 118.68 21.18M115.77 20.67C115.77 19.59 115.96 18.53 116.33 17.49C116.7 16.45 117.25 15.52 117.97 14.7C118.69 13.88 119.58 13.22 120.63 12.72C121.68 12.22 122.89 11.98 124.27 11.98C124.83 11.98 125.46 12.03 126.15 12.12C126.84 12.21 127.37 12.37 127.76 12.59V7.44995H130.91V28.33C129.98 28.76 129.03 29.08 128.05 29.29C127.07 29.5 126.1 29.61 125.16 29.61C123.92 29.61 122.73 29.42 121.61 29.03C120.48 28.65 119.48 28.08 118.61 27.34C117.74 26.6 117.05 25.66 116.55 24.55C116.04 23.43 115.79 22.14 115.79 20.67H115.77Z"
                                  fill="white"/>
                            <path d="M143.6 14.7501C142.9 14.7501 142.23 14.84 141.59 15.02C140.95 15.2 140.37 15.47 139.86 15.83C139.35 16.19 138.93 16.65 138.61 17.2C138.28 17.75 138.09 18.4101 138.02 19.1801L139.85 19.11C140.23 19.16 140.7 19.1801 141.25 19.1901C141.8 19.2001 142.34 19.21 142.86 19.21C143.31 19.21 143.76 19.1801 144.21 19.1301C144.66 19.0801 145.06 18.96 145.41 18.79C145.76 18.62 146.04 18.39 146.26 18.1C146.47 17.81 146.58 17.43 146.58 16.98C146.58 16.17 146.28 15.5901 145.67 15.2501C145.06 14.9101 144.37 14.7401 143.61 14.7401L143.6 14.7501ZM149.08 27.51C148.29 28.07 147.37 28.58 146.3 29.02C145.24 29.46 144.03 29.6801 142.68 29.6801C141.57 29.6801 140.55 29.5201 139.62 29.1901C138.68 28.8601 137.87 28.39 137.18 27.79C136.49 27.18 135.94 26.42 135.52 25.52C135.1 24.62 134.87 23.5901 134.83 22.4401V22.27C134.47 22.31 134.1 22.34 133.73 22.35C133.36 22.36 132.99 22.43 132.63 22.57V19.4901C133.01 19.3801 133.39 19.31 133.75 19.29C134.11 19.27 134.48 19.2301 134.87 19.1901C134.94 18.1101 135.19 17.11 135.61 16.21C136.04 15.31 136.61 14.5301 137.34 13.8701C138.06 13.2201 138.92 12.71 139.91 12.35C140.9 11.99 142 11.8101 143.19 11.8101C144.48 11.8101 145.64 12.09 146.68 12.66C147.47 13.11 148.12 13.73 148.64 14.52C149.16 15.31 149.42 16.2001 149.42 17.1901C149.42 18.1801 149.07 19.2 148.37 20.1C147.65 21.05 146.78 21.6601 145.78 21.9401C144.78 22.2201 143.69 22.36 142.51 22.36C141.99 22.36 141.39 22.34 140.7 22.29C140.01 22.24 139.39 22.22 138.82 22.22C138.66 22.22 138.52 22.2201 138.38 22.2401C138.24 22.2501 138.12 22.27 138.01 22.29V22.46C138.01 23.79 138.46 24.8001 139.35 25.4901C140.24 26.1801 141.35 26.52 142.68 26.52C143.36 26.52 143.98 26.46 144.56 26.35C145.14 26.24 145.68 26.0801 146.18 25.8801C146.69 25.6801 147.18 25.44 147.65 25.17C148.12 24.9 148.6 24.61 149.07 24.29V27.51H149.08Z"
                                  stroke="white" stroke-width="0.7" stroke-linecap="square" stroke-linejoin="round"/>
                            <path d="M143.601 14.7501C142.901 14.7501 142.231 14.84 141.591 15.02C140.951 15.2 140.371 15.47 139.861 15.83C139.351 16.19 138.931 16.65 138.611 17.2C138.281 17.75 138.091 18.4101 138.021 19.1801L139.851 19.11C140.231 19.16 140.701 19.1801 141.251 19.1901C141.801 19.2001 142.341 19.21 142.861 19.21C143.311 19.21 143.761 19.1801 144.211 19.1301C144.661 19.0801 145.061 18.96 145.411 18.79C145.761 18.62 146.041 18.39 146.261 18.1C146.471 17.81 146.581 17.43 146.581 16.98C146.581 16.17 146.281 15.5901 145.671 15.2501C145.061 14.9101 144.371 14.7401 143.611 14.7401M149.091 27.5001C148.301 28.0601 147.381 28.57 146.311 29.01C145.251 29.45 144.041 29.67 142.691 29.67C141.581 29.67 140.561 29.5101 139.631 29.1801C138.691 28.8501 137.881 28.38 137.191 27.78C136.501 27.17 135.951 26.41 135.531 25.51C135.111 24.61 134.881 23.5801 134.841 22.4301V22.26C134.481 22.3 134.111 22.33 133.741 22.34C133.371 22.35 133.001 22.4201 132.641 22.5601V19.48C133.021 19.37 133.401 19.3 133.761 19.28C134.121 19.26 134.491 19.2201 134.881 19.1801C134.951 18.1001 135.201 17.1 135.621 16.2C136.051 15.3 136.621 14.52 137.351 13.86C138.071 13.21 138.931 12.7 139.921 12.34C140.911 11.98 142.011 11.8 143.201 11.8C144.491 11.8 145.651 12.08 146.691 12.65C147.481 13.1 148.131 13.72 148.651 14.51C149.171 15.3 149.431 16.1901 149.431 17.1801C149.431 18.1701 149.081 19.19 148.381 20.09C147.661 21.04 146.791 21.6501 145.791 21.9301C144.791 22.2101 143.701 22.35 142.521 22.35C142.001 22.35 141.401 22.33 140.711 22.28C140.021 22.23 139.401 22.21 138.831 22.21C138.671 22.21 138.531 22.21 138.391 22.23C138.251 22.24 138.131 22.26 138.021 22.28V22.45C138.021 23.78 138.471 24.79 139.361 25.48C140.251 26.17 141.361 26.51 142.691 26.51C143.371 26.51 143.991 26.45 144.571 26.34C145.151 26.23 145.691 26.0701 146.191 25.8701C146.701 25.6701 147.191 25.43 147.661 25.16C148.131 24.89 148.611 24.6 149.081 24.28V27.5001H149.091Z"
                                  fill="white"/>
                            <path d="M155.45 7.97998H152.47V29.27H155.45V7.97998Z" stroke="white" stroke-width="0.7"
                                  stroke-linecap="square" stroke-linejoin="round"/>
                            <path d="M155.45 7.97998H152.47V29.27H155.45V7.97998Z" fill="white"/>
                            <path d="M171.52 26.9C171.36 27.51 171.06 28.01 170.62 28.41C170.18 28.8 169.71 29.11 169.2 29.32C168.69 29.53 168.19 29.68 167.69 29.76C167.19 29.84 166.81 29.8801 166.54 29.8801C165.25 29.8801 164.14 29.72 163.21 29.41C162.27 29.09 161.51 28.6 160.91 27.92C160.31 27.24 159.87 26.36 159.57 25.26C159.28 24.17 159.13 22.84 159.13 21.28V12.3101H162.18V21.3801C162.18 22.0801 162.24 22.7501 162.35 23.3801C162.46 24.0101 162.68 24.58 162.99 25.07C163.31 25.57 163.73 25.97 164.28 26.27C164.82 26.57 165.53 26.76 166.41 26.83C167.02 26.83 167.63 26.7201 168.24 26.4901C168.85 26.2601 169.39 25.9301 169.86 25.4901C170.33 25.0501 170.72 24.5101 171.03 23.8801C171.33 23.2501 171.49 22.53 171.49 21.71V12.3H174.57V29.26H171.49L171.52 26.89V26.9Z"
                                  stroke="white" stroke-width="0.7" stroke-linecap="square" stroke-linejoin="round"/>
                            <path d="M171.52 26.9C171.36 27.51 171.06 28.01 170.62 28.41C170.18 28.8 169.71 29.11 169.2 29.32C168.69 29.53 168.19 29.68 167.69 29.76C167.19 29.84 166.81 29.8801 166.54 29.8801C165.25 29.8801 164.14 29.72 163.21 29.41C162.27 29.09 161.51 28.6 160.91 27.92C160.31 27.24 159.87 26.36 159.57 25.26C159.28 24.17 159.13 22.84 159.13 21.28V12.3101H162.18V21.3801C162.18 22.0801 162.24 22.7501 162.35 23.3801C162.46 24.0101 162.68 24.58 162.99 25.07C163.31 25.57 163.73 25.97 164.28 26.27C164.82 26.57 165.53 26.76 166.41 26.83C167.02 26.83 167.63 26.7201 168.24 26.4901C168.85 26.2601 169.39 25.9301 169.86 25.4901C170.33 25.0501 170.72 24.5101 171.03 23.8801C171.33 23.2501 171.49 22.53 171.49 21.71V12.3H174.57V29.26H171.49L171.52 26.89V26.9Z"
                                  fill="white"/>
                            <path d="M183.28 20.64L176.82 12.35H180.61L185.15 18.2L189.68 12.35H193.47L187.08 20.64L193.68 29.3H189.95L185.15 23.08L180.34 29.3H176.62L183.28 20.64Z"
                                  stroke="white" stroke-width="0.7" stroke-linecap="square" stroke-linejoin="round"/>
                            <path d="M183.28 20.64L176.82 12.35H180.61L185.15 18.2L189.68 12.35H193.47L187.08 20.64L193.68 29.3H189.95L185.15 23.08L180.34 29.3H176.62L183.28 20.64Z"
                                  fill="white"/>
                            <path d="M58.96 43.2299V37.1699H63.03V38.2099H60.14V39.7699H62.54V40.7199H60.14V43.2299H58.96Z"
                                  fill="white"/>
                            <path d="M69.5294 40.8899L68.6994 38.3899L67.8594 40.8899H69.5294ZM68.0994 37.1699H69.2894L71.5094 43.2199H70.2994L69.7994 41.7099H67.5794L67.0694 43.2199H65.8594L68.0894 37.1699H68.0994Z"
                                  fill="white"/>
                            <path d="M76.39 38.1799V39.7099H77.96C78.09 39.7099 78.21 39.6799 78.32 39.6199C78.43 39.5599 78.51 39.4699 78.58 39.3599C78.65 39.2499 78.68 39.1099 78.68 38.9499C78.68 38.7899 78.65 38.6599 78.59 38.5499C78.53 38.4399 78.45 38.3499 78.35 38.2899C78.25 38.2299 78.14 38.1999 78.01 38.1999H76.39V38.1799ZM78.9 41.4399C78.9 41.2899 78.87 41.1499 78.81 41.0299C78.75 40.9099 78.66 40.8099 78.56 40.7399C78.45 40.6699 78.33 40.6299 78.2 40.6299H76.39V42.2199H78.14C78.28 42.2199 78.41 42.1799 78.53 42.1099C78.65 42.0399 78.74 41.9399 78.81 41.8199C78.88 41.6999 78.91 41.5699 78.91 41.4299L78.9 41.4399ZM80.08 41.6599C80.08 41.9999 79.99 42.2899 79.82 42.5199C79.64 42.7499 79.41 42.9199 79.11 43.0399C78.81 43.1599 78.49 43.2199 78.13 43.2199H75.21V37.1699H78.45C78.73 37.1699 78.98 37.2499 79.19 37.3999C79.4 37.5499 79.56 37.7399 79.67 37.9799C79.78 38.2199 79.84 38.4599 79.84 38.7199C79.84 39.0099 79.77 39.2899 79.62 39.5499C79.47 39.8099 79.26 39.9999 78.97 40.1299C79.32 40.2299 79.59 40.4199 79.79 40.6799C79.99 40.9499 80.09 41.2799 80.09 41.6699L80.08 41.6599Z"
                                  fill="white"/>
                            <path d="M85.2203 40.1699H86.6903C86.8403 40.1699 86.9703 40.1299 87.0803 40.0399C87.1903 39.9499 87.2803 39.8299 87.3503 39.6899C87.4203 39.5399 87.4503 39.3799 87.4503 39.1999C87.4503 39.0099 87.4103 38.8399 87.3303 38.6899C87.2503 38.5399 87.1503 38.4299 87.0303 38.3399C86.9103 38.2499 86.7803 38.2099 86.6303 38.2099H85.2103V40.1699H85.2203ZM84.0403 43.2299V37.1799H86.7203C87.0003 37.1799 87.2603 37.2399 87.4903 37.3499C87.7303 37.4599 87.9303 37.6199 88.1003 37.8099C88.2703 37.9999 88.4103 38.2199 88.5003 38.4599C88.5903 38.6999 88.6403 38.9399 88.6403 39.1899C88.6403 39.4399 88.6003 39.6899 88.5103 39.9299C88.4203 40.1699 88.3003 40.3699 88.1303 40.5499C87.9703 40.7299 87.7703 40.8599 87.5503 40.9599L88.9303 43.2399H87.6303L86.3903 41.2099H85.2103V43.2399H84.0303L84.0403 43.2299Z"
                                  fill="white"/>
                            <path d="M93.93 37.1699H92.75V43.2199H93.93V37.1699Z" fill="white"/>
                            <path d="M97.8499 40.15C97.8499 39.78 97.9198 39.42 98.0498 39.06C98.1798 38.7 98.3799 38.38 98.6299 38.09C98.8899 37.8 99.1999 37.56 99.5699 37.39C99.9399 37.22 100.36 37.13 100.83 37.13C101.39 37.13 101.87 37.25 102.27 37.5C102.68 37.74 102.98 38.06 103.18 38.45L102.28 39.0699C102.18 38.8399 102.04 38.66 101.88 38.53C101.72 38.4 101.54 38.3 101.35 38.25C101.16 38.2 100.98 38.17 100.8 38.17C100.5 38.17 100.25 38.23 100.03 38.35C99.8098 38.47 99.6299 38.6299 99.4799 38.8199C99.3299 39.0099 99.2198 39.23 99.1498 39.47C99.0798 39.71 99.0399 39.95 99.0399 40.19C99.0399 40.46 99.0799 40.71 99.1699 40.96C99.2599 41.21 99.3798 41.43 99.5298 41.62C99.6898 41.81 99.8698 41.9599 100.09 42.0699C100.31 42.1799 100.55 42.24 100.81 42.24C101 42.24 101.19 42.21 101.38 42.15C101.57 42.09 101.75 41.99 101.92 41.85C102.08 41.71 102.21 41.5399 102.3 41.3199L103.26 41.87C103.14 42.17 102.95 42.43 102.68 42.64C102.41 42.85 102.11 43.01 101.77 43.12C101.43 43.23 101.1 43.28 100.77 43.28C100.34 43.28 99.9398 43.1899 99.5898 43.0099C99.2298 42.8299 98.9199 42.59 98.6699 42.29C98.4099 41.99 98.2098 41.66 98.0598 41.28C97.9198 40.91 97.8398 40.53 97.8398 40.15"
                                  fill="white"/>
                            <path d="M110.09 40.8899L109.26 38.3899L108.42 40.8899H110.09ZM108.66 37.1699H109.85L112.07 43.2199H110.86L110.36 41.7099H108.14L107.63 43.2199H106.42L108.65 37.1699H108.66Z"
                                  fill="white"/>
                            <path d="M127.689 40.1899C127.689 39.7999 127.619 39.4499 127.479 39.1499C127.339 38.8499 127.129 38.6199 126.869 38.4499C126.599 38.2799 126.279 38.1999 125.899 38.1999H124.879V42.1899H125.899C126.289 42.1899 126.609 42.0999 126.879 41.9299C127.149 41.7599 127.349 41.5199 127.489 41.2099C127.629 40.9099 127.699 40.5599 127.699 40.1799M123.699 43.2099V37.1599H125.899C126.559 37.1599 127.109 37.2899 127.549 37.5599C127.989 37.8299 128.329 38.1899 128.549 38.6499C128.769 39.1099 128.879 39.6099 128.879 40.1699C128.879 40.7799 128.759 41.3199 128.509 41.7699C128.269 42.2199 127.919 42.5799 127.469 42.8299C127.019 43.0799 126.499 43.2099 125.889 43.2099H123.689H123.699Z"
                                  fill="white"/>
                            <path d="M137.03 42.1899V43.2299H132.83V37.1699H136.96V38.2099H134.01V39.6599H136.56V40.6199H134.01V42.1899H137.03Z"
                                  fill="white"/>
                            <path d="M154.26 37.1699V43.2299H153.09V40.6399H150.35V43.2299H149.17V37.1699H150.35V39.6199H153.09V37.1699H154.26Z"
                                  fill="white"/>
                            <path d="M168.49 40.1699H169.96C170.11 40.1699 170.24 40.1299 170.35 40.0399C170.46 39.9499 170.55 39.8299 170.62 39.6899C170.69 39.5399 170.72 39.3799 170.72 39.1999C170.72 39.0099 170.68 38.8399 170.6 38.6899C170.52 38.5399 170.42 38.4299 170.3 38.3399C170.18 38.2499 170.05 38.2099 169.9 38.2099H168.48V40.1699H168.49ZM167.31 43.2299V37.1799H169.99C170.27 37.1799 170.53 37.2399 170.76 37.3499C171 37.4599 171.2 37.6199 171.37 37.8099C171.54 37.9999 171.68 38.2199 171.77 38.4599C171.86 38.6999 171.91 38.9399 171.91 39.1899C171.91 39.4399 171.87 39.6899 171.78 39.9299C171.69 40.1699 171.57 40.3699 171.4 40.5499C171.24 40.7299 171.04 40.8599 170.82 40.9599L172.2 43.2399H170.9L169.66 41.2099H168.48V43.2399H167.3L167.31 43.2299Z"
                                  fill="white"/>
                            <path d="M180.479 38.2099H178.539V43.2299H177.369V38.2099H175.439V37.1699H180.479V38.2099Z"
                                  fill="white"/>
                            <path d="M185.44 37.1699H184.26V43.2199H185.44V37.1699Z" fill="white"/>
                            <path d="M193.93 42.1899V43.2299H189.73V37.1699H193.86V38.2099H190.91V39.6599H193.46V40.6199H190.91V42.1899H193.93Z"
                                  fill="white"/>
                            <path d="M159.48 36.2899L160.38 35.4299H161.21L162.11 36.2899L161.52 36.5599L160.8 36.0199L160.08 36.5599L159.48 36.2899ZM161.63 40.8899L160.8 38.3899L159.96 40.8899H161.63ZM160.2 37.1699H161.39L163.61 43.2199H162.4L161.9 41.7099H159.68L159.17 43.2199H157.96L160.19 37.1699H160.2Z"
                                  fill="white"/>
                            <path d="M58.96 43.2299V37.1699H63.03V38.2099H60.14V39.7699H62.54V40.7199H60.14V43.2299H58.96Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M69.5294 40.8899L68.6994 38.3899L67.8594 40.8899H69.5294ZM68.0994 37.1699H69.2894L71.5094 43.2199H70.2994L69.7994 41.7099H67.5794L67.0694 43.2199H65.8594L68.0894 37.1699H68.0994Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M76.39 38.1799V39.7099H77.96C78.09 39.7099 78.21 39.6799 78.32 39.6199C78.43 39.5599 78.51 39.4699 78.58 39.3599C78.65 39.2499 78.68 39.1099 78.68 38.9499C78.68 38.7899 78.65 38.6599 78.59 38.5499C78.53 38.4399 78.45 38.3499 78.35 38.2899C78.25 38.2299 78.14 38.1999 78.01 38.1999H76.39V38.1799ZM78.9 41.4399C78.9 41.2899 78.87 41.1499 78.81 41.0299C78.75 40.9099 78.66 40.8099 78.56 40.7399C78.45 40.6699 78.33 40.6299 78.2 40.6299H76.39V42.2199H78.14C78.28 42.2199 78.41 42.1799 78.53 42.1099C78.65 42.0399 78.74 41.9399 78.81 41.8199C78.88 41.6999 78.91 41.5699 78.91 41.4299L78.9 41.4399ZM80.08 41.6599C80.08 41.9999 79.99 42.2899 79.82 42.5199C79.64 42.7499 79.41 42.9199 79.11 43.0399C78.81 43.1599 78.49 43.2199 78.13 43.2199H75.21V37.1699H78.45C78.73 37.1699 78.98 37.2499 79.19 37.3999C79.4 37.5499 79.56 37.7399 79.67 37.9799C79.78 38.2199 79.84 38.4599 79.84 38.7199C79.84 39.0099 79.77 39.2899 79.62 39.5499C79.47 39.8099 79.26 39.9999 78.97 40.1299C79.32 40.2299 79.59 40.4199 79.79 40.6799C79.99 40.9499 80.09 41.2799 80.09 41.6699L80.08 41.6599Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M85.2203 40.1699H86.6903C86.8403 40.1699 86.9703 40.1299 87.0803 40.0399C87.1903 39.9499 87.2803 39.8299 87.3503 39.6899C87.4203 39.5399 87.4503 39.3799 87.4503 39.1999C87.4503 39.0099 87.4103 38.8399 87.3303 38.6899C87.2503 38.5399 87.1503 38.4299 87.0303 38.3399C86.9103 38.2499 86.7803 38.2099 86.6303 38.2099H85.2103V40.1699H85.2203ZM84.0403 43.2299V37.1799H86.7203C87.0003 37.1799 87.2603 37.2399 87.4903 37.3499C87.7303 37.4599 87.9303 37.6199 88.1003 37.8099C88.2703 37.9999 88.4103 38.2199 88.5003 38.4599C88.5903 38.6999 88.6403 38.9399 88.6403 39.1899C88.6403 39.4399 88.6003 39.6899 88.5103 39.9299C88.4203 40.1699 88.3003 40.3699 88.1303 40.5499C87.9703 40.7299 87.7703 40.8599 87.5503 40.9599L88.9303 43.2399H87.6303L86.3903 41.2099H85.2103V43.2399H84.0303L84.0403 43.2299Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M93.93 37.1699H92.75V43.2199H93.93V37.1699Z" stroke="white" stroke-width="0.22"
                                  stroke-miterlimit="22.93"/>
                            <path d="M97.8499 40.15C97.8499 39.78 97.9198 39.42 98.0498 39.06C98.1798 38.7 98.3799 38.38 98.6299 38.09C98.8899 37.8 99.1999 37.56 99.5699 37.39C99.9399 37.22 100.36 37.13 100.83 37.13C101.39 37.13 101.87 37.25 102.27 37.5C102.68 37.74 102.98 38.06 103.18 38.45L102.28 39.0699C102.18 38.8399 102.04 38.66 101.88 38.53C101.72 38.4 101.54 38.3 101.35 38.25C101.16 38.2 100.98 38.17 100.8 38.17C100.5 38.17 100.25 38.23 100.03 38.35C99.8098 38.47 99.6299 38.6299 99.4799 38.8199C99.3299 39.0099 99.2198 39.23 99.1498 39.47C99.0798 39.71 99.0399 39.95 99.0399 40.19C99.0399 40.46 99.0799 40.71 99.1699 40.96C99.2599 41.21 99.3798 41.43 99.5298 41.62C99.6898 41.81 99.8698 41.9599 100.09 42.0699C100.31 42.1799 100.55 42.24 100.81 42.24C101 42.24 101.19 42.21 101.38 42.15C101.57 42.09 101.75 41.99 101.92 41.85C102.08 41.71 102.21 41.5399 102.3 41.3199L103.26 41.87C103.14 42.17 102.95 42.43 102.68 42.64C102.41 42.85 102.11 43.01 101.77 43.12C101.43 43.23 101.1 43.28 100.77 43.28C100.34 43.28 99.9398 43.1899 99.5898 43.0099C99.2298 42.8299 98.9199 42.59 98.6699 42.29C98.4099 41.99 98.2098 41.66 98.0598 41.28C97.9198 40.91 97.8398 40.53 97.8398 40.15H97.8499Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M110.09 40.8899L109.26 38.3899L108.42 40.8899H110.09ZM108.66 37.1699H109.85L112.07 43.2199H110.86L110.36 41.7099H108.14L107.63 43.2199H106.42L108.65 37.1699H108.66Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M127.69 40.1899C127.69 39.7999 127.62 39.4499 127.48 39.1499C127.34 38.8499 127.13 38.6199 126.87 38.4499C126.6 38.2799 126.28 38.1999 125.9 38.1999H124.88V42.1899H125.9C126.29 42.1899 126.61 42.0999 126.88 41.9299C127.15 41.7599 127.35 41.5199 127.49 41.2099C127.63 40.9099 127.7 40.5599 127.7 40.1799L127.69 40.1899ZM123.69 43.2199V37.1699H125.89C126.55 37.1699 127.1 37.2999 127.54 37.5699C127.98 37.8399 128.32 38.1999 128.54 38.6599C128.76 39.1199 128.87 39.6199 128.87 40.1799C128.87 40.7899 128.75 41.3299 128.5 41.7799C128.26 42.2299 127.91 42.5899 127.46 42.8399C127.01 43.0899 126.49 43.2199 125.88 43.2199H123.68H123.69Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M137.03 42.1899V43.2299H132.83V37.1699H136.96V38.2099H134.01V39.6599H136.56V40.6199H134.01V42.1899H137.03Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M154.26 37.1699V43.2299H153.09V40.6399H150.35V43.2299H149.17V37.1699H150.35V39.6199H153.09V37.1699H154.26Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M168.49 40.1699H169.96C170.11 40.1699 170.24 40.1299 170.35 40.0399C170.46 39.9499 170.55 39.8299 170.62 39.6899C170.69 39.5399 170.72 39.3799 170.72 39.1999C170.72 39.0099 170.68 38.8399 170.6 38.6899C170.52 38.5399 170.42 38.4299 170.3 38.3399C170.18 38.2499 170.05 38.2099 169.9 38.2099H168.48V40.1699H168.49ZM167.31 43.2299V37.1799H169.99C170.27 37.1799 170.53 37.2399 170.76 37.3499C171 37.4599 171.2 37.6199 171.37 37.8099C171.54 37.9999 171.68 38.2199 171.77 38.4599C171.86 38.6999 171.91 38.9399 171.91 39.1899C171.91 39.4399 171.87 39.6899 171.78 39.9299C171.69 40.1699 171.57 40.3699 171.4 40.5499C171.24 40.7299 171.04 40.8599 170.82 40.9599L172.2 43.2399H170.9L169.66 41.2099H168.48V43.2399H167.3L167.31 43.2299Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M180.479 38.2099H178.539V43.2299H177.369V38.2099H175.439V37.1699H180.479V38.2099Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M185.44 37.1699H184.26V43.2199H185.44V37.1699Z" stroke="white" stroke-width="0.22"
                                  stroke-miterlimit="22.93"/>
                            <path d="M193.93 42.1899V43.2299H189.73V37.1699H193.86V38.2099H190.91V39.6599H193.46V40.6199H190.91V42.1899H193.93Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path d="M159.48 36.2899L160.38 35.4299H161.21L162.11 36.2899L161.52 36.5599L160.8 36.0199L160.08 36.5599L159.48 36.2899ZM161.63 40.8899L160.8 38.3899L159.96 40.8899H161.63ZM160.2 37.1699H161.39L163.61 43.2199H162.4L161.9 41.7099H159.68L159.17 43.2199H157.96L160.19 37.1699H160.2Z"
                                  stroke="white" stroke-width="0.22" stroke-miterlimit="22.93"/>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M24.35 0C37.8 0 48.7 10.9 48.7 24.35C48.7 37.8 37.8 48.7 24.35 48.7C10.9 48.7 0 37.8 0 24.35C0 10.9 10.9 0 24.35 0Z"
                                  fill="#103648"/>
                            <path d="M24.3497 3.17993C36.0397 3.17993 45.5197 12.6599 45.5197 24.3499C45.5197 36.0399 36.0397 45.5199 24.3497 45.5199C12.6597 45.5199 3.17969 36.0399 3.17969 24.3499C3.17969 12.6599 12.6597 3.17993 24.3497 3.17993Z"
                                  stroke="white" stroke-width="1.99" stroke-miterlimit="22.93"/>
                            <path d="M41.6863 27.6732C43.5295 18.1013 37.2642 8.84736 27.6922 7.00409C18.1203 5.16082 8.86635 11.4262 7.02308 20.9981C5.17981 30.5701 11.4452 39.824 21.0171 41.6673C30.5891 43.5105 39.843 37.2452 41.6863 27.6732Z"
                                  stroke="white" stroke-width="1.99" stroke-miterlimit="22.93"/>
                            <path d="M24.3602 10.23C32.1602 10.23 38.4803 16.55 38.4803 24.35C38.4803 32.15 32.1602 38.47 24.3602 38.47C16.5602 38.47 10.2402 32.15 10.2402 24.35C10.2402 16.55 16.5602 10.23 24.3602 10.23Z"
                                  stroke="white" stroke-width="1.99" stroke-miterlimit="22.93"/>
                            <path d="M24.3595 13.76C30.2095 13.76 34.9496 18.5 34.9496 24.35C34.9496 30.2 30.2095 34.9401 24.3595 34.9401C18.5095 34.9401 13.7695 30.2 13.7695 24.35C13.7695 18.5 18.5095 13.76 24.3595 13.76Z"
                                  stroke="white" stroke-width="1.99" stroke-miterlimit="22.93"/>
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                  d="M21.2402 5.70001L21.1003 4.81006L24.6802 4.71002V0.26001L35.0302 2.45001C38.8902 4.34001 42.1803 7.22001 44.5703 10.76L48.0502 18.73C48.3902 20.18 48.6003 21.67 48.6703 23.2L46.7502 28.39L43.2502 27.45L42.8802 30.23L35.2102 30.29L20.9902 30.17L21.2402 5.69006V5.70001Z"
                                  fill="#103648"/>
                            <path d="M37.9801 24.33H29.5801V27.36H37.9801V24.33Z" fill="#103648"/>
                            <path d="M26.2805 9.13H24.7305V33.61H26.2805V9.13Z" fill="#103648"/>
                            <path d="M26.2805 9.13H24.7305V33.61H26.2805V9.13Z" stroke="#103648" stroke-width="0.57"
                                  stroke-miterlimit="22.93"/>
                            <path d="M29.8003 9.3999H28.2803V30.2299H29.8003V9.3999Z" fill="#103648"/>
                            <mask id="mask0_369_924" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="2" y="2"
                                  width="45" height="45">
                                <path d="M24.3495 2.28003C36.5395 2.28003 46.4295 12.16 46.4295 24.36C46.4295 36.56 36.5495 46.4401 24.3495 46.4401C12.1495 46.4401 2.26953 36.56 2.26953 24.36C2.26953 12.16 12.1495 2.28003 24.3495 2.28003Z"
                                      fill="white"/>
                            </mask>
                            <g mask="url(#mask0_369_924)">
                                <path d="M27.3203 2.15002V24.2401H46.3003" stroke="white" stroke-width="1.99"
                                      stroke-miterlimit="22.93"/>
                                <path d="M30.9697 2.15002V20.55H46.5797" stroke="white" stroke-width="2"
                                      stroke-miterlimit="22.93"/>
                                <path d="M34.5898 2.44006V16.7501H46.5898" stroke="white" stroke-width="2.02"
                                      stroke-miterlimit="22.93"/>
                                <path d="M23.75 2.15002V27.8701H46.97" stroke="white" stroke-width="1.99"
                                      stroke-miterlimit="22.93"/>
                            </g>
                            <path d="M29.9096 46.46C29.8196 46.46 29.7396 46.46 29.6496 46.46C27.4296 46.46 25.3396 45.65 23.7696 44.16C22.1896 42.66 21.3496 40.61 21.3496 38.49V32.87H44.6296V32.99C48.0796 33.42 50.7596 36.22 50.7796 39.59V39.71C50.7796 39.71 50.7796 39.73 50.7796 39.74C50.7796 41.53 50.0396 43.22 48.6996 44.49C47.3596 45.76 45.5796 46.46 43.6896 46.45C43.6796 46.45 43.6696 46.45 43.6596 46.45C42.0396 46.45 35.4196 46.45 29.9296 46.46H29.9096Z"
                                  fill="#103648"/>
                            <path d="M24.8098 43.2099C23.5098 41.9899 22.7998 40.3599 22.7998 38.6299V28.6499H44.7598L43.1898 32.9299H41.6698C41.6698 32.9299 41.6298 32.9099 41.6098 32.9099C41.6098 32.9099 33.1198 32.9099 32.0498 32.9099C29.1298 32.9099 27.0598 34.5099 26.9098 36.8999C26.8398 38.0099 27.1798 39.0099 27.8898 39.7099C28.5498 40.3699 29.4498 40.7199 30.4998 40.7199H35.9798C35.7498 41.7799 35.3098 42.6699 34.6798 43.3599C33.6298 44.5099 32.0298 45.0899 29.9398 45.0899C29.8498 45.0899 29.7498 45.0899 29.6598 45.0899C27.8298 45.0899 26.1098 44.4199 24.8098 43.1999"
                                  fill="white"/>
                            <path d="M28.3303 37.2C28.3303 37.13 28.3303 37.0701 28.3303 37.0001C28.4603 35.0001 30.3303 34.29 32.0303 34.29C33.4203 34.29 34.6403 35.0201 35.4003 36.1301H31.5303C32.6403 37.1601 31.9703 39.3801 30.3803 39.3801C29.0603 39.3801 28.3203 38.43 28.3203 37.21"
                                  fill="white"/>
                            <path d="M36.1795 38.67C36.1795 38.91 36.1795 39.14 36.1595 39.37H33.0195C33.2895 38.93 33.4895 38.32 33.4295 37.48L36.0195 37.5C36.1195 37.88 36.1696 38.27 36.1696 38.68"
                                  fill="#103648"/>
                            <path d="M34.8105 45.09C35.1505 44.84 35.4706 44.5701 35.7606 44.2501C36.9906 42.9001 37.6205 41.03 37.6205 38.67C37.6205 36.9 36.8506 35.32 35.6306 34.27H41.5406C41.5406 34.27 41.5806 34.27 41.6006 34.27H43.7405C46.8105 34.3 49.3205 36.68 49.3405 39.58V39.7C49.3405 39.7 49.3405 39.71 49.3405 39.72C49.3405 41.15 48.7505 42.49 47.6805 43.51C46.6205 44.51 45.2106 45.07 43.7206 45.07C43.7206 45.07 43.7006 45.07 43.6906 45.07C42.5706 45.07 38.8505 45.07 34.8105 45.07"
                                  fill="white"/>
                        </svg>
                    </div><!-- .site-name -->
                </div><!-- .site-info -->
                <p><?php echo pll_e('Angajându-ne ferm către o lume mai verde, fabrica noastră transformă cu pasiune materiale reciclabile în produse de înaltă calitate, aducând astfel o contribuție esențială la protejarea mediului și la promovarea unui viitor sustenabil.') ?></p>
            </div>
            <div class="column">
                <h3><?php echo pll_e('Informații utile') ?></h3>
                <?php if (has_nav_menu('footer')) : ?>
                    <nav aria-label="<?php esc_attr_e('Secondary menu', 'twentytwentyone'); ?>"
                         class="footer-navigation">
                        <ul class="footer-navigation-wrapper">
                            <?php
                            wp_nav_menu(
                                array(
                                    'theme_location' => 'footer',
                                    'items_wrap' => '%3$s',
                                    'container' => false,
                                    'depth' => 1,
                                    'link_before' => '<span>',
                                    'link_after' => '</span>',
                                    'fallback_cb' => false,
                                )
                            );
                            ?>
                        </ul><!-- .footer-navigation-wrapper -->
                    </nav><!-- .footer-navigation -->
                <?php endif; ?>
            </div>
            <div class="column">
                <h3><?php echo pll_e('Importator oficial în România') ?></h3>
                <p><?php echo pll_e('Intelotan Papir SRL') ?></p>
                <p><?php echo pll_e('Jud. Prahova, Ploiești') ?></p>
                <p><?php echo pll_e('Telefon') ?>:<a href="tel:+40746200007">+40 (746) 200007</a></p>
            </div>
            <div class="column">
                <h3><?php echo pll_e('Contacte') ?></h3>
                <a href="mailto:info@candelux.md">info@candelux.md</a>
                <p><?php echo pll_e('str. Uzinelor 19, Chisinau, R. Moldova') ?></p>
            </div>
        </div>
        <div class="bottom_footer">
            <p><span><?php echo pll_e('Copyright ©Candelux 2024. Toate drepturile rezervate.') ?></span></p>
            <p><span><?php echo pll_e('Creat de') ?></span> <a href="https://zazitex.com"><img
                            src="https://zazitex.com/wp-content/themes/zazitex/assets/images/zazitex.svg" alt="zazitex"></a>
            </p>
        </div>
    </div>
    <?php echo do_shortcode('[elfsight_whatsapp_chat id="4"]') ?>

    <div class="modal_overlay_survey" id="modalUser">
        <div class="modal_iterested modal" tabindex="-1" role="dialog">
            <div class="close"><img src="/wp-content/themes/twentytwentyone-child/assets/img/close.svg" alt=""></div>
            <?php echo do_shortcode('[contact-form-7 id="3e969e0" title="Survey"]') ?>
        </div>
    </div>
</footer><!-- #colophon -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"
        integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js"
        integrity="sha512-XtmMtDEcNz2j7ekrtHvOVR4iwwaD6o/FUJe6+Zq+HgcCsk3kj4uSQQR8weQ2QVj1o0Pk6PwYLohm206ZzNfubg=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="/wp-content/themes/twentytwentyone-child/assets/js/main.js"></script>
<script src="/wp-content/themes/twentytwentyone-child/assets/js/lightbox.js"></script>
<script src="/wp-content/themes/twentytwentyone-child/assets/js/slick.min.js"></script>
<script src="/wp-content/themes/twentytwentyone-child/assets/js/jquery.jqZoom.js"></script>
<script src="/wp-content/themes/twentytwentyone-child/assets/js/jquery.cookie.js"></script>

</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
