<?php
/*
 * Template name: Contact Us
 * Template post type: Page
 */ ?>

<?php get_header() ?>
<div class="contact_wrap">
    <img src="/wp-content/themes/twentytwentyone-child/assets/img/half_circles.png" alt="" class="top_circles">
    <div class="container">
        <div class="contacts">
            <div class="top_section">
                <div class="left_side">
                    <h6><?php echo pll_e('Contacte') ?></h6>
                    <h1><?php echo pll_e('Contactează-ne!') ?></h1>
                </div>
                <p><?php echo pll_e('Suntem aici pentru a răspunde întrebărilor tale și pentru a oferi asistență în orice fel avem posibilitatea. Pentru informații suplimentare despre produsele noastre sau pentru a discuta despre oportunități de colaborare, nu ezita să ne contactezi folosind detaliile de mai jos.') ?></p>
            </div>
            <div class="contact_form">
                <?php echo do_shortcode('[contact-form-7 id="6374678" title="Formular de contact 1"]') ?>
            </div>
            <div class="contacts_details">
                <p>
                    <svg xmlns="http://www.w3.org/2000/svg" width="17" height="24" viewBox="0 0 17 24" fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                              d="M0 9.18889C0 3.75016 4.25266 0.5 8.36364 0.5C12.4746 0.5 16.7273 3.75016 16.7273 9.18889C16.7273 14.9568 9.03912 23.0104 8.71146 23.3502C8.61946 23.4463 8.49401 23.5 8.36364 23.5C8.23326 23.5 8.10781 23.4463 8.01581 23.3502C7.68815 23.0104 0 14.9568 0 9.18889ZM5.41176 9.18893C5.41176 10.8802 6.73568 12.2556 8.36364 12.2556C9.99159 12.2556 11.3155 10.8802 11.3155 9.18893C11.3155 7.49766 9.99159 6.12226 8.36364 6.12226C6.73568 6.12226 5.41176 7.49766 5.41176 9.18893Z"
                              fill="#267DA9"/>
                    </svg>
                    <span><?php echo pll_e('str. Uzinelor 19') ?></span>
                </p>
                <p>
                    <svg xmlns="http://www.w3.org/2000/svg" width="23" height="20" viewBox="0 0 23 20" fill="none">
                        <path d="M20.5 0.339966H2.5C1.11929 0.339966 8.60676e-09 1.46331 8.60676e-09 2.84904V4.85629C-3.38582e-05 5.03993 0.0998818 5.20892 0.2605 5.29688L11.2605 11.3187C11.4098 11.4004 11.5902 11.4004 11.7395 11.3187L22.7395 5.29688C22.9001 5.20892 23 5.03993 23 4.85629V2.84904C23 1.46331 21.8807 0.339966 20.5 0.339966Z"
                              fill="#267DA9"/>
                        <path d="M12.2185 12.5746C11.7712 12.8149 11.2308 12.8149 10.7835 12.5746L0.0115 6.77997L0 6.78737V17.194C0 18.5559 1.11929 19.66 2.5 19.66H20.5C21.8807 19.66 23 18.5559 23 17.194V6.78737L22.9885 6.78046L12.2185 12.5746Z"
                              fill="#267DA9"/>
                    </svg>
                    <span><a href="mailto:info@candelux.md">info@candelux.md</a></span>
                </p>
                <p>
                    <svg xmlns="http://www.w3.org/2000/svg" width="23" height="24" viewBox="0 0 23 24" fill="none">
                        <path d="M15.3564 14.7045L13.4818 17.0479C10.5784 15.3418 8.15877 12.9225 6.4524 10.0192L8.79535 8.14473C9.36036 7.69282 9.54936 6.91665 9.25537 6.25558L7.11942 1.44646C6.80294 0.733925 6.01717 0.35521 5.26262 0.551544L1.19721 1.60537C0.411808 1.81021 -0.0960661 2.57032 0.0152726 3.37429C1.48187 13.8133 9.6866 22.018 20.1259 23.4848C20.9299 23.5959 21.6898 23.0881 21.8949 22.3029L22.9488 18.2366C23.1444 17.4823 22.7658 16.6971 22.0538 16.3804L17.2456 14.2471C16.585 13.9529 15.8092 14.1408 15.3564 14.7045Z"
                              fill="#267DA9"/>
                    </svg>
                    <span class="block">
                    <span>
                    <b><?php echo pll_e('Anticamera:') ?></b>
                    <a href="tel:+37368903031">+(373) 68 903 031</a>
                </span>
                <span>
                    <b><?php echo pll_e('Contabilitate:') ?></b>
                    <a href="tel:+37369501341">+(373) 69 501 341</a>
                </span>
                <span>
                    <b><?php echo pll_e('Secția Vânzări:') ?></b>
                    <a href="tel:+37360525025">+(373) 78 305 011</a>
                    <a href="mailto:comercial@candelux.md">comercial@candelux.md</a>
                    </a>
                </span>
                <span>
                    <b><?php echo pll_e('Secția Achiziție maculatură:') ?></b>
                    <a href="tel:+37368195151">+(373) 68 195151</a>
                </span>

                </span>
                </p>
            </div>
        </div>
    </div>
</div>
<div class="map">
    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2287.596885526679!2d28.876111633681464!3d47.01223285763074!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x40c97c0966f451a7%3A0xf000119dd563be5b!2sCandelux-Com!5e0!3m2!1sro!2s!4v1717586927874!5m2!1sro!2s"
            width="100%" height="600" style="border:0;" allowfullscreen="" loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"></iframe>
</div>
<?php get_footer() ?>
