<?php
/**
 * Template name: Branding
 * Template post type: page
 */
?>
<?php get_header() ?>
<div class="branding">
    <img src="/wp-content/themes/twentytwentyone-child/assets/img/half_circles_green.png" alt="" class="middle_circles">

    <div class="container">
        <div class="top_section">
            <div class="text_side">
                <h6><?php echo pll_e('branding personal') ?></h6>
                <h1><?php echo pll_e('Descriere strategică') ?></h1>
                <p><?php echo pll_e('Serviciul de personal branding oferit de compania Candelux este conceput pentru a sprijini producătorii și distribuitorii de hârtie igienică din materiale reciclate să construiască și să consolideze o imagine puternică și distinctă pe piață.') ?></p>
                <p><?php echo pll_e('Acest serviciu se axează pe dezvoltarea unei identități de brand unice, crearea de campanii de comunicare eficiente și promovarea valorilor sustenabile ale produsului.') ?></p>
                <p><?php echo pll_e('Serviciul de personal branding oferit de Candelux reprezintă un parteneriat strategic pentru companiile din industria respectivă, oferindu-le instrumentele necesare pentru a deveni lideri de piață printr-o imagine de brand puternică și distinctivă.') ?></p>
            </div>
            <div class="img_side">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/branding1.png" alt="">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/branding2.png" alt="">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/circles.png" alt="" class="points">
            </div>
        </div>
        <div class="service_destination">
            <h2><?php echo pll_e('Destinatarii serviciului') ?></h2>
            <div class="single_services">
                <div class="head">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 48 48" fill="none">
                        <path d="M20.3675 14.2218C28.8548 14.2218 35.7351 11.7097 35.7351 8.6109C35.7351 5.51209 28.8548 3 20.3675 3C11.8803 3 5 5.51209 5 8.6109C5 11.7097 11.8803 14.2218 20.3675 14.2218Z"
                              stroke="#41AE76" stroke-width="2" stroke-miterlimit="10"/>
                        <path d="M5 8.31403V40.1152C5 43.2177 11.8819 45.7223 20.3675 45.7223C24.9519 45.7223 28.3864 45.1931 31.2269 44.296C37.7112 42.0937 43 36.3609 43 36.3609V6.67676C40.1595 9.20958 32.8108 11.9046 32.8108 11.9046"
                              stroke="#41AE76" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round"
                              stroke-linejoin="round"/>
                        <path d="M20.3676 14.2227V16.7509" stroke="#41AE76" stroke-width="2" stroke-linecap="round"
                              stroke-linejoin="round"/>
                        <path d="M20.3676 22.0439V40.5413" stroke="#41AE76" stroke-width="2" stroke-linecap="round"
                              stroke-linejoin="round"/>
                        <path d="M20.3676 43.1846V45.7204" stroke="#41AE76" stroke-width="2" stroke-linecap="round"
                              stroke-linejoin="round"/>
                        <path d="M20.0325 10.2488C22.0256 10.2488 23.6414 9.51232 23.6414 8.60387C23.6414 7.69543 22.0256 6.95898 20.0325 6.95898C18.0394 6.95898 16.4236 7.69543 16.4236 8.60387C16.4236 9.51232 18.0394 10.2488 20.0325 10.2488Z"
                              stroke="#41AE76" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <h6><?php echo pll_e('Producători de hârtie igienică') ?></h6>
                </div>
                <p><?php echo pll_e('Companii care doresc să își promoveze produsele ecologice și să creeze o identitate de brand puternică.') ?></p>
            </div>
            <div class="single_services">
                <div class="head">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 48 48" fill="none">
                        <g clip-path="url(#clip0_465_6274)">
                            <path d="M20.5714 34.5596V41.4167C20.5625 41.6744 20.4539 41.9186 20.2683 42.0977C20.0828 42.2768 19.835 42.3769 19.5771 42.3767H12.3771C11.1933 42.1773 10.1216 41.5562 9.35999 40.6281"
                                  stroke="#41AE76" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M9.36001 40.6622C9.36001 40.6622 5.62287 37.405 14.2972 28.7308H18.1714L12.3772 19.165H1.71429L4.62858 22.9022C4.62858 22.9022 2.67429 23.245 2.67429 25.9536C3.69934 31.3191 5.99156 36.3619 9.36001 40.6622V40.6622Z"
                                  stroke="#41AE76" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M35.4857 21.8395L40.56 18.4109C40.6734 18.3608 40.796 18.335 40.92 18.335C41.044 18.335 41.1666 18.3608 41.28 18.4109C41.4124 18.4264 41.5397 18.4714 41.6525 18.5426C41.7652 18.6138 41.8605 18.7094 41.9314 18.8223L45.8743 24.7195C46.1099 25.1936 46.2325 25.7158 46.2325 26.2452C46.2325 26.7746 46.1099 27.2968 45.8743 27.7709"
                                  stroke="#41AE76" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M46.0115 27.4287C46.0115 27.4287 44.9143 31.8859 33.5657 30.8573V27.8744L26.9143 36.583L33.2229 46.2859L33.5657 41.7259C33.5657 41.7259 34.8343 43.2687 36.9943 41.7259C40.6168 37.3783 43.6488 32.5709 46.0115 27.4287V27.4287Z"
                                  stroke="#41AE76" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M14.9143 14.6739L10.2857 12.5482C10.0574 12.4302 9.88156 12.2311 9.79273 11.9899C9.70389 11.7488 9.70853 11.4832 9.80573 11.2453L13.7143 3.42815C13.9754 2.96534 14.3406 2.56955 14.7809 2.27204C15.2212 1.97454 15.7246 1.78345 16.2514 1.71387"
                                  stroke="#41AE76" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M16.2515 1.71394C16.2515 1.71394 20.4686 1.71394 25.8172 11.9997L23.04 15.4282H34.56L38.64 4.66251L33.84 6.1368C33.7703 5.39289 33.5009 4.68163 33.0603 4.07815C32.6198 3.47467 32.0245 3.00136 31.3372 2.70823C28.974 1.92589 26.4862 1.58876 24 1.71394H16.2515Z"
                                  stroke="#41AE76" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_465_6274">
                                <rect width="48" height="48" fill="white"/>
                            </clipPath>
                        </defs>
                    </svg>
                    <h6><?php echo pll_e('Distribuitori de produse ecologice') ?></h6>
                </div>
                <p><?php echo pll_e('Distribuitorii care vor să adauge valoare portofoliului lor, prin  promovarea produselor sustenabile.') ?></p>
            </div>
            <div class="single_services">
                <div class="head">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 48 48" fill="none">
                        <path d="M7 22V28C7 35.542 7 39.314 9.344 41.656C11.686 44 15.458 44 23 44H25C32.542 44 36.314 44 38.656 41.656C41 39.314 41 35.542 41 28V22"
                              stroke="#41AE76" stroke-width="2"/>
                        <path d="M19 4H29L30.304 17.034C30.3899 17.9135 30.2908 18.8013 30.0131 19.6403C29.7354 20.4792 29.2852 21.2507 28.6915 21.9053C28.0977 22.5598 27.3736 23.0829 26.5656 23.4409C25.7577 23.7988 24.8837 23.9837 24 23.9837C23.1163 23.9837 22.2424 23.7988 21.4344 23.4409C20.6264 23.0829 19.9023 22.5598 19.3086 21.9053C18.7148 21.2507 18.2646 20.4792 17.9869 19.6403C17.7092 18.8013 17.6101 17.9135 17.696 17.034L19 4Z"
                              stroke="#41AE76" stroke-width="2"/>
                        <path d="M6.66005 10.702C7.01605 8.922 7.19405 8.032 7.55605 7.31C7.93324 6.55808 8.46433 5.89387 9.11485 5.3605C9.76537 4.82713 10.5208 4.43651 11.332 4.214C12.112 4 13.02 4 14.836 4H19L17.55 18.49C17.4735 19.3193 17.2286 20.1242 16.8302 20.8555C16.4318 21.5868 15.8883 22.2291 15.233 22.743C14.5778 23.257 13.8245 23.6318 13.0194 23.8446C12.2142 24.0573 11.3741 24.1035 10.5505 23.9803C9.72688 23.8571 8.93707 23.5671 8.22942 23.128C7.52178 22.689 6.91118 22.1101 6.43502 21.4269C5.95886 20.7437 5.62714 19.9705 5.46019 19.1546C5.29323 18.3387 5.29454 17.4973 5.46405 16.682L6.66005 10.702ZM41.34 10.702C40.984 8.922 40.806 8.032 40.444 7.31C40.0669 6.55808 39.5358 5.89387 38.8852 5.3605C38.2347 4.82713 37.4793 4.43651 36.668 4.214C35.888 4 34.98 4 33.164 4H29L30.45 18.49C30.5266 19.3193 30.7715 20.1242 31.1699 20.8555C31.5683 21.5868 32.1118 22.2291 32.7671 22.743C33.4223 23.257 34.1756 23.6318 34.9807 23.8446C35.7859 24.0573 36.626 24.1035 37.4496 23.9803C38.2732 23.8571 39.063 23.5671 39.7707 23.128C40.4783 22.689 41.0889 22.1101 41.5651 21.4269C42.0412 20.7437 42.3729 19.9705 42.5399 19.1546C42.7069 18.3387 42.7055 17.4973 42.536 16.682L41.34 10.702Z"
                              stroke="#41AE76" stroke-width="2"/>
                        <path d="M19 43V37C19 35.13 19 34.196 19.402 33.5C19.6653 33.044 20.044 32.6653 20.5 32.402C21.196 32 22.13 32 24 32C25.87 32 26.804 32 27.5 32.402C27.956 32.6653 28.3347 33.044 28.598 33.5C29 34.196 29 35.13 29 37V43"
                              stroke="#41AE76" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                    <h6><?php echo pll_e('Retaileri') ?></h6>
                </div>
                <p><?php echo pll_e('Magazinele care doresc să ofere clienților produse ecologice și să își îmbunătățească imaginea prin asocierea cu branduri sustenabile.') ?></p>
            </div>
            <div class="single_services">
                <div class="head">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 48 48" fill="none">
                        <path d="M26 42V28L16 18L6 28V42H16M26 42H16M26 42H42V8C42 7.46957 41.7893 6.96086 41.4142 6.58579C41.0391 6.21071 40.5304 6 40 6H20C19.4696 6 18.9609 6.21071 18.5858 6.58579C18.2107 6.96086 18 7.46957 18 8V20M16 42V34M26 14V14.02M34 14V14.02M34 22V22.02M34 30V30.02"
                              stroke="#41AE76" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <h6><?php echo pll_e('Organizații și instituții') ?></h6>
                </div>
                <p><?php echo pll_e('Entități care promovează sustenabilitatea și doresc să includă produse ecologice în oferta lor.') ?></p>
            </div>
        </div>
        <div class="advantages">
            <h2><?php echo pll_e('Avantaje pentru antreprenori') ?></h2>
            <div class="single_advantage">
                <h6><?php echo pll_e('Diferențiere competitivă') ?></h6>
                <p><?php echo pll_e('Un brand puternic și bine definit ajută producătorii și distribuitorii să se diferențieze de concurență.') ?></p>
            </div>
            <div class="single_advantage">
                <h6><?php echo pll_e('Acces la noi segmente de piață') ?></h6>
                <p><?php echo pll_e('Prin promovarea valorilor ecologice și sustenabile, atragem consumatori preocupați de mediu și creștem baza de clienți.') ?></p>
            </div>
            <div class="single_advantage">
                <h6><?php echo pll_e('Creșterea valorii brandului') ?></h6>
                <p><?php echo pll_e('O strategie de personal branding eficientă poate duce la creșterea percepției pozitive a brandului și, implicit, a valorii acestuia pe piață.') ?></p>
            </div>
            <div class="single_advantage">
                <h6><?php echo pll_e('Îmbunătățirea imaginii publice') ?></h6>
                <p><?php echo pll_e('Asocierea cu valori ecologice și sustenabile contribuie la îmbunătățirea imaginii publice a companiei, atrăgând astfel parteneriate și colaborări benefice.') ?></p>
            </div>
            <div class="single_advantage">
                <h6><?php echo pll_e('Sustenabilitate pe termen lung') ?></h6>
                <p><?php echo pll_e('Investiția în personal branding pentru produse ecologice sprijină dezvoltarea sustenabilă a afacerii pe termen lung.') ?></p>
            </div>
            <div class="single_advantage">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/branding4.png" alt="">
            </div>
        </div>
    </div>
</div>
<?php get_footer() ?>
