jQuery(function ($) {
    $(document).ready(function () {

        $('.accordion_header').on('click', function () {
            $('.single_accordion').removeClass('active')
            $(this).closest('.single_accordion').toggleClass('active')
        })

        $('.objectives_slider').slick({
            slidesToShow: 4,
            slidesToScroll: 1,
            centerMode: false,
            infinite: false,
            arrow: false,
            responsive: [{
                breakpoint: 991,
                settings: {
                    slidesToShow: 2.5,
                    prevArrow: $('.left_arrow'),
                    nextArrow: $('.right_arrow'),
                }
            }, {
                breakpoint: 768,
                settings: {
                    slidesToShow: 1.5,
                    prevArrow: $('.left_arrow'),
                    nextArrow: $('.right_arrow'),
                }
            }]
        })
        $('.burger').on('click', function () {
            $('.primary-navigation').addClass('active')
        })
        $('.close').on('click', function () {
            $('.primary-navigation').removeClass('active')
        })

        $('.mobile_burger_categories').on('click', function () {
            $('.sidebar').addClass('active')
        })
        $('.close_sidebar').on('click', function () {
            $('.sidebar').removeClass('active')
        })
        $('.top_slider .wp-block-gallery').slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            asNavFor: '.bottom_slider .wp-block-gallery',
            arrows: false,
            fade: true,
            infinite: false,

        })


        $('.bottom_slider .wp-block-gallery').slick({
            slidesToShow: 2,
            slidesToScroll: 1,
            asNavFor: '.top_slider .wp-block-gallery',
            focusOnSelect: true,
            infinite: false,
        })

        // Back tot top
        var back_to_top = function () {
            $(window).scroll(function () {
                if ($(this).scrollTop() > 400) {
                    $('#back-to-top').addClass('active');
                } else {
                    $('#back-to-top').removeClass('active');
                }
            });
            $('#back-to-top').on('click', function () {
                $('html, body').animate({scrollTop: '0px'}, 800);
                console.log('++++++')

            });
        };

        back_to_top();

        //
        // $(".top_slider .wp-block-image img").jqZoom({
        //     selectorWidth: 30,
        //     selectorHeight: 30,
        //     viewerWidth: 400,
        //     viewerHeight: 400
        // });


        $('#modalUser').fadeOut();
        // Check for the "whenToShowDialog" cookie, if not found then show the dialog and save the cookie.
        // The cookie will expire and every 2 days and the dialog will show again.
        if ($.cookie('whenToShowDialog') == null) {
            // Create expiring cookie, 2 days from now:
            $.cookie('whenToShowDialog', 'yes', {expires: 30, path: '/'});
            // Show dialog
            $('#modalUser').fadeIn();
        }
        $('.modal_overlay_survey .close, .wpcf7-submit').on('click', function () {
            $('#modalUser').fadeOut(); // Now the pop up is hiden.
        })

        $('.answers input[type="radio"]').on('click', function () {
            $('.survey input[type="submit"]').trigger('click');
        })

        document.addEventListener('wpcf7submit', function (event) {
            setTimeout(function () {
                $('form.wpcf7-form').removeClass('sent');
                $('form.wpcf7-form').removeClass('failed');
                $('form.wpcf7-form').addClass('init');
            }, 0);

        }, false);


    })
})