<?php
/**
 * Template name: Produse
 * Template post type: page
 */
?>
<?php get_header() ?>
<div class="product_wrap">
    <img src="/wp-content/themes/twentytwentyone-child/assets/img/half_circles.png" alt="" class="top_circles">
    <div class="container">
        <div class="products_page">
            <div class="sidebar">
                <div class="close_sidebar">
                    <img src="/wp-content/themes/twentytwentyone-child/assets/img/close_bue.png" alt="Close">
                </div>
                <?php if (has_nav_menu('tax_menu')) : ?>
                    <nav aria-label="<?php esc_attr_e('Secondary menu', 'twentytwentyone'); ?>"
                         class="sidebar_navigation">
                        <ul class="sidebar_navigation_wrapper">
                            <?php
                            wp_nav_menu(
                                array(
                                    'theme_location' => 'tax_menu',
                                    'items_wrap' => '%3$s',
                                    'container' => false,
                                    'depth' => 2,
                                    'fallback_cb' => false,
                                )
                            );
                            ?>
                        </ul><!-- .footer-navigation-wrapper -->
                    </nav><!-- .footer-navigation -->
                <?php endif; ?>
            </div>
            <div class="products">
                <div class="text">
                    <h6><?php echo pll_e('produse') ?></h6>
                    <h1><?php echo pll_e('Descoperă gama noastră de produse') ?></h1>
                    <div class="mobile_burger_categories">
                    <span>
                        <span></span>
                        <span></span>
                        <span></span>
                    </span>
                        <p><?php echo pll_e('Categorii') ?></p>
                    </div>
                </div>
                <?php
                // Definim tipul de post personalizat
                $custom_post_type = 'produse'; // Înlocuiește cu slug-ul tipului de post personalizat

                // Setăm argumentele interogării
                $args = array(
                    'post_type' => $custom_post_type,
                    'posts_per_page' => -1, // Obținem toate postările
                    'post_status' => 'publish', // Obținem doar postările publicate
                    'order_by' => 'date',
                    'order' => 'ASC'
                );

                // Creăm noua interogare
                $custom_posts_query = new WP_Query($args);

                // Verificăm dacă avem postări
                if ($custom_posts_query->have_posts()) {
                    echo '<ul>';
                    while ($custom_posts_query->have_posts()) {
                        $custom_posts_query->the_post();
                        echo '<li>';
                        // Afișăm imaginea reprezentativă
                        if (has_post_thumbnail()) {
                            echo '<div class="post-thumbnail"><a href="' . get_the_permalink() . '">' . get_the_post_thumbnail(get_the_ID(), 'full') . '</a></div>';
                        }
                        echo '<div class="product_content">';
                        // Afișăm titlul și link-ul către postare
                        echo '<a href="' . get_the_permalink() . '"><h4>' . get_the_title() . '</h4></a>';

                        echo '</div>';

                        echo '</li>';
                    }
                    echo '</ul>';
                } else {
                    echo '<p>No posts found.</p>';
                }

                // Resetăm post data
                wp_reset_postdata();

                ?>
            </div>
        </div>
    </div>
    <img src="/wp-content/themes/twentytwentyone-child/assets/img/half_circles.png" alt="" class="bottom_circles">
</div>
<?php get_footer() ?>
