<?php
/*
 * Template name: About Us
 * Template post type: Page
 */
?>
<?php get_header() ?>
<div class="about_us">

    <div class="container">
        <div class="top_section">
            <div class="img_side">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/about_img1.png" alt="">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/about_img2.png" alt="">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/circles.png" class="points" alt="">
            </div>
            <div class="text_side">
                <h6><?php echo pll_e('Despre noi') ?></h6>
                <h1><?php echo pll_e('Cine suntem') ?></h1>
                <p>
                    <b><?php echo pll_e('Candelux-Com este un producător de renume în domeniul hârtiei igienice și semifabricatelor de hârtie, cu o prezență solidă pe piața din Republica Moldova timp de peste 14 ani.') ?></b>
                </p>
                <div class="blocks">
                    <div class="block">
                        <div class="number">
                            <span>14+</span>
                            <p><?php echo pll_e('Ani pe piață') ?></p>
                        </div>
                        <p><?php echo pll_e('Evoluția noastră începe în 1999, când am început să activăm cu un portofoliu modest de doar 5 produse. De atunci, am crescut și ne-am adaptat cerințelor pieței, ajungând să producem mai mult de 20 de articole, devenind liderul de piață în domeniul achiziției și reciclării deșeurilor de hârtie.') ?></p>
                    </div>
                    <div class="block">
                        <div class="number">
                            <span>20+</span>
                            <p><?php echo pll_e('Articole proprii') ?></p>
                        </div>
                        <p><?php echo pll_e('Suntem prima companie de profil pe teritoriul Republicii Moldova, având ca domeniu de activitate achiziția și reciclarea deșeurilor de hârtie. Produsele noastre sunt create pentru a răspunde specificului consumatorului autohton și sunt rezultatul experienței producătorilor din comunitatea europeană.') ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="our_objectives">
            <div class="text">
                <h2><?php echo pll_e('Obiectivele noastre') ?></h2>
                <p><?php echo pll_e('Obiectivele noastre de dezvoltare sunt îndreptate către extinderea continuă a pieței de desfacere și aducerea produselor noastre la standarde europene de calitate și sustenabilitate.') ?></p>
                <p><?php echo pll_e('Ne străduim să fim un partener de încredere pentru clienții noștri, oferindu-le soluții inovatoare și de înaltă calitate pentru nevoile lor de igienă și curățenie.') ?></p>
            </div>
            <div class="objectives_slider">
                <div>
                    <div class="slider">
                        <h5><?php echo pll_e('Extinderea gamei de produse') ?></h5>
                        <p><?php echo pll_e('Obiectivul de a dezvolta și lansa noi produse sau linii de produse pentru a satisface nevoile în continuă schimbare ale clienților și pentru a răspunde cerințelor pieței.') ?></p>
                    </div>
                </div>
                <div>
                    <div class="slider">
                        <h5><?php echo pll_e('Îmbunătățirea calității și eficienței procesului de producție') ?></h5>
                        <p><?php echo pll_e('Concentrarea pe optimizarea proceselor de producție pentru a asigura calitatea constantă a produselor și pentru a îmbunătăți eficiența operațională.') ?></p>
                    </div>
                </div>
                <div>
                    <div class="slider">
                        <h5><?php echo pll_e('Dezvoltarea piețelor noi') ?></h5>
                        <p><?php echo pll_e('Identificarea și exploatarea oportunităților de piață în regiuni noi sau segmente de clienți pentru a extinde baza de clienți și a crește veniturile.') ?></p>
                    </div>
                </div>
                <div>
                    <div class="slider">
                        <h5><?php echo pll_e('Sustenabilitate și responsabilitate socială') ?></h5>
                        <p><?php echo pll_e('Implementarea practicilor de producție responsabile din punct de vedere social și ecologic, în conformitate cu standardele internaționale, pentru a contribui la protejarea mediului și la promovarea bunăstării comunităților locale.') ?></p>
                    </div>
                </div>
            </div>
            <div class="arrows">
                <div class="left_arrow arrow">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="12" viewBox="0 0 18 12" fill="none">
                        <path d="M18 6.00024L1 6.00024M1 6.00024L6 11.0002M1 6.00024L6 1.00024" stroke="#41AE76"/>
                    </svg>
                </div>
                <div class="right_arrow arrow">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="12" viewBox="0 0 18 12" fill="none">
                        <path d="M0 6H17M17 6L12 1M17 6L12 11" stroke="#41AE76"/>
                    </svg>
                </div>
            </div>
        </div>
        <div class="top_section bottom_section">
            <div class="text_side">
                <h2><?php echo pll_e('Misiunea și viziunea companiei') ?></h2>
                <p><?php echo pll_e('Misiunea noastră este să rămânem lideri în domeniul nostru, oferind produse de cea mai bună calitate și respectând mediul înconjurător.') ?></p>
                <p><?php echo pll_e('Viziunea noastră este de a deveni un jucător important în industria hârtiei, inovând continuu și oferind soluții sustenabile și eficiente pentru clienții noștri din întreaga lume.') ?></p>
            </div>
            <div class="img_side">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/about_3.png" alt="">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/about_4.png" alt="">
                <img src="/wp-content/themes/twentytwentyone-child/assets/img/circles.png" class="points" alt="">
            </div>
        </div>
    </div>
    <img src="/wp-content/themes/twentytwentyone-child/assets/img/europe_map.png" alt="" class="bottom_map">
</div>
<?php get_footer() ?>
